# -*- coding: UTF-8 -*-
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.constant import CheckedResult
from common.contextUtil import getLang
from common.cTV1R1 import cHandleCliRet

def execute(context):
    '''
    @summary: the entrance of main method, this check item is used to check Thin LUN Capacity
    @param context: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    errMsg = ''
    cliRet = ''
    lang = getLang(context)
    thinLunCapacity = ""
    temp = ""
    cliRet = getCliRet(context,"showlun", False)
    lunList = cliRet.splitlines()
    #判断cli回显信息是否满足要求
    if len(lunList) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."
        return (flag, cliRet, errMsg)
    lunLstDict = cHandleCliRet(cliRet).handle()
    for dictInfo in lunLstDict:
        if 'THIN' == unicode(dictInfo.get('Lun Type')).upper():
            thinLunCapacity = dictInfo["Visible Capacity(Mb)"]
            if thinLunCapacity[-2:] == ".5":
                temp = int(float(thinLunCapacity))
                if temp == 0:
                    continue
                elif temp%1024 == 0:
                    flag = CheckedResult.NOTPASS
                    if lang == "zh":
                        errMsg += u"Thin LUN（ID:%s）容量为%sMB。\n" %(dictInfo['Id'],thinLunCapacity)
                    else:
                        errMsg += "The capacity of Thin LUN(ID:%s) is %s MB.\n" %(dictInfo['Id'],thinLunCapacity)
    
    return (flag, cliRet, errMsg)