# -*- coding: UTF-8 -*-

import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger


"""ThinPool休眠状态检查"""
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check thin pool spindown status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    """
    showpooliospindown 
    ==============================================
             Pool IO Spindown Information
    ----------------------------------------------
      Pool ID    Spindown Status    Idle Time(s)  
    ----------------------------------------------
      0          Not Spindown       --            
    ==============================================
    
    admin:/>showpoolprdspindown 
    command operates successfully, but no information.
    admin:/>
    """
    flag = CheckedResult.PASS
    lang = getLang(dataDict)
    errMsg = ""
    cliRet = ""
    
    ioSleepInfo = getCliRet(dataDict, "showpooliospindown")
    cliRet += ioSleepInfo
    prdSleepInfo = getCliRet(dataDict, "showpoolprdspindown")
    cliRet+= "\n" + prdSleepInfo
    
    #判断不定时休眠信息
    if re.search("command operates successfully", ioSleepInfo, re.IGNORECASE):
        pass
    elif re.search("license", ioSleepInfo, re.IGNORECASE):
        pass
    elif re.search("not exist", ioSleepInfo, re.IGNORECASE):
        pass
    elif re.search("not support", ioSleepInfo, re.IGNORECASE):
        pass
    elif re.search("IO Spindown", ioSleepInfo, re.IGNORECASE):
        lineList = ioSleepInfo.splitlines()
        if len(lineList) > 7:
            for line in lineList[6:]:
                field = line.split()
                if len(field) < 3:
                    continue
                else:
                    if re.search("Not Spindown", line, re.IGNORECASE) and re.search("--", line, re.IGNORECASE):
                        continue
                    else:
                        flag = CheckedResult.NOTPASS
                        if "zh" == lang:
                            errMsg += u"系统设置了Thin Pool休眠，会导致升级失败。"
                        else:
                            errMsg += "The storage system contains Thin Pool which is set to spin_down, which can result in upgrade failure."
                        break
    else:
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg += u"Thin Pool状态存在异常, 获取Thin Pool休眠信息失败。"
        else:
            errMsg += "The status of Thin Pool is abnormal. Get the spindown information failed."

    #如果不定时休眠检查失败，则检查不通过
    if flag == CheckedResult.NOTPASS:
        return (flag, cliRet, errMsg)
    
    #判断 定时休眠信息
    if re.search("command operates successfully", prdSleepInfo, re.IGNORECASE):
        pass
    elif re.search("license", prdSleepInfo, re.IGNORECASE):
        pass
    elif re.search("not exist", prdSleepInfo, re.IGNORECASE):
        pass
    elif re.search("not support", ioSleepInfo, re.IGNORECASE):
        pass
    elif len(prdSleepInfo.splitlines()) > 7:
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg += u"系统设置了Thin Pool休眠，会导致升级失败。"
        else:
            errMsg += "The storage system contains Thin Pool which is set to spin_down, which can result in upgrade failure."
    else:
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg += u"Thin Pool状态存在异常, 获取Thin Pool休眠信息失败。"
        else:
            errMsg += "The status of Thin Pool is abnormal. Get the spindown information failed."
    return (flag, cliRet, errMsg)

