# -*- coding: UTF-8 -*-
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger



def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Thin Pool Status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    errMsg = ""
    lang = getLang(dataDict) 
   
    cliRet = getCliRet(dataDict, "showpool", False)
    lineList = cliRet.splitlines()
    if len(lineList) < 7:
        #判断cli信息是否有效
        if not checkCliInfoValid(cliRet):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)
    
    #查询ThinPool状态
    for line in lineList[6:]:
        field = line.split()
        if len(field) < 4:
            continue
        
        poolId = field[0]
        status = field[3]
        if status != "Normal":
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg += u"\nThin Pool " + poolId + u"的状态异常（" + unicode(status) + u"）。"
            else:
                errMsg += "\nThe status of Thin Pool " + poolId + " is abnormal(" + unicode(status) + ")."

    #检查结果返回
    return (flag, cliRet, errMsg)