# -*- coding: UTF-8 -*-

from java.lang import Exception
import os
import re
from common import compressionManager
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger, getSftpObj, getCurSysVer
from common.modelManager import *
from cbb.frame.util.tar_util import decompress_tar_all_file


# **************************************************************************** #
# 函数名称: decompressPKG
# 功能说明: 解压告警文件
# 输入参数: filePath, depressPath
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def decompressPKG(filePath, depressPath):
    decompress_tar_all_file(filePath, depressPath)


# **************************************************************************** #
# 函数名称: getPath
# 功能说明: 获取告警文件路径
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def getPath(strRet):
    strs = strRet.splitlines()
    
    #获取远端阵列上的临时文件全路径
    for line in strs:
        if line.find("Path :") != -1:
            lineSub = line[line.index("Path :"):]
            remotePath = lineSub.replace("Path :", "")
            return remotePath
       
    return ""

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Unrecovered Alarms
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    """取得传入参数"""    
    log = getLogger(dataDict)
    sftp = getSftpObj(dataDict)
    lang = getLang(dataDict)
    
    flag = CheckedResult.PASS
    errMsg = ""
    cliRet = ""

    #获取系统软件版本号,判断是否需要提示屏蔽
    currentVer = getCurSysVer(dataDict)
    log.info("Current system version:" + currentVer)
    if currentVer in ["V100R002C00SPC010", "V100R002C01SPC007", "V100R002C01SPC008", "V100R002C01SPC009", "V100R002C01SPC010"]:  
        flag = CheckedResult.WARN
        if lang == "zh":
            errMsg += u"当前版本不支持此操作，请通过登录ISM查看是否存在未恢复告警。"
        else:
            errMsg += "\nThe operation is not supported, please check the unrecovered alarm by ISM."
            
        return (flag, cliRet, errMsg)

    #通过cli回文查看是否支持在阵列目录下生成告警文件
    cliRet = getCliRet(dataDict, "exportsysevent -t alarm")
    if not bool(re.search("Path", cliRet, re.IGNORECASE)):
        flag = CheckedResult.WARN
        if lang == "zh":
            errMsg += u"\n获取告警文件失败，请登录ISM查看是否存在未恢复告警。"
        else:
            errMsg += "\nFailed to get alarm file, please check the unrecovered alarm by ISM."
            
        return (flag, cliRet, errMsg)  
        
    remoteFile = getPath(unicode(cliRet))
    
    #获取数据解压临时文件夹
    collectTmpDir = compressionManager.getCollectTmpDir(dataDict)
    
    #创建临时文件夹
    if not os.path.exists(collectTmpDir):
        os.makedirs(collectTmpDir)

    localFile = collectTmpDir + os.sep + 'event_export.tar'
    
    try:
        sftp.getFile(remoteFile, localFile, None)
    except Exception:
        flag = CheckedResult.WARN
        if lang == "zh":
            errMsg += u"\n下载告警文件失败，请登录ISM查看是否存在未恢复告警。"
        else:
            errMsg += "\nFailed to download alarm file, please check the unrecovered alarm by ISM."
        
        return (flag, cliRet, errMsg)
    finally:
        if remoteFile:
            compressionManager.deleteRemoteFile(dataDict, remoteFile)
             
    decompressPKG(collectTmpDir + os.sep + 'event_export.tar', collectTmpDir)
    #打开告警文件
    try:
        alarmFile = open(collectTmpDir + os.sep + 'local_alm_file.txt', "r")
    except IOError:
        flag = CheckedResult.WARN
        if lang == "zh":
            errMsg += u"\n打开告警文件失败，请登录ISM查看是否存在未恢复告警。"
        else:
            errMsg += "\nFailed to open alarm file, please check the unrecovered alarm by ISM."

        return (flag, cliRet, errMsg)

    alarmIDs = []
    cliRet0 = "Raised  Local Time    Alarm ID    Alarm Level    Recovered Local Time    Description\n"
    for line in alarmFile:
        if line.find("Event list") >= 0:
            break
        
        list = line.split()
        if len(list) < 5:
            continue
        if list[4] != "None":
            continue
        
        #P12V-2935 警告级别告警也需要检查 modified 20130731 Begin
        #P12V-2721  未恢复告警级别检查优化 modified 20130509 Begin
        if list[3] not in ("Major", "Critical", "Warning", "Minor"):
            continue
        #P12V-2721  未恢复告警级别检查优化 modified 20130509 End
        #P12V-2935 警告级别告警也需要检查 modified 20130731 End
        
        flag = CheckedResult.NOTPASS
        # 将Suggestion字段之前的字符串添加到原始信息cliRet中。
        index = line.find("Step 1")
        cliRet0 += line[0:index]
        cliRet0 += "\n"

        alarmIDs.append(list[2])
    alarmFile.close()
    
    if flag == CheckedResult.NOTPASS:
        if lang == "zh":
            errMsg += u"\n系统存在未恢复告警：" + unicode(alarmIDs).replace("[", "").replace("]", "") + u"。"
        else:
            errMsg += "\nThere are unrecovered alarms: " + unicode(alarmIDs).replace("[", "").replace("]", "") + "."
    else:
        cliRet0 = cliRet
    
    return (flag, cliRet0, errMsg)

#P12V-2830 安全红线后未恢复告警检查 added 20130605 End