# -*- coding: UTF-8 -*-

from java.lang import Exception
import os
import re
from common import compressionManager
from common.constant import CheckedResult
from common.contextUtil import getLang, getLogger, getSshObj, getSftpObj, getTimeStamp
from common.modelManager import *
from cbb.frame.util.tar_util import decompress_tar_all_file

# **************************************************************************** #
# 函数名称: decompressPKG
# 功能说明: 解压告警文件
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def decompressPKG(filePath, depressPath):
    decompress_tar_all_file(filePath, depressPath)


# **************************************************************************** #
# 函数名称: getPath
# 功能说明: 获取告警文件路径
# 输入参数: ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
# MML>alarm exportevent
# export event [success]: file path = [{ip}:/OSM/export_import/event_export.tar].
def getPath(mmlInfo):
    lineList = mmlInfo.splitlines()    
    path = ""
    
    for line in lineList:
        if re.search("path", line, re.IGNORECASE):
            path = line[line.index(":/") + 1 : -2]
            break
        else:
            continue
            
    return path


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Unrecovered Alarms
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    """取得传入参数"""
    ssh = getSshObj(dataDict)
    sftp = getSftpObj(dataDict)
    lang = getLang(dataDict)

    flag = CheckedResult.PASS
    errMsg = ''
    
    """安全红线前的版本可以进入MML查询"""
    iRet = changeCli2Mml(dataDict)
    if False == iRet:
        flag = CheckedResult.WARN
        # 设备登陆时输入developer密码无效 modified 20131130 Begin
        if lang == "zh":
            errMsg = u"进入MML模式失败，未恢复告警检查失败。失败的原因可能为：\n" \
                    + u"（1）添加设备时未输入developer密码。\n（2）添加设备时输入的developer密码无效。"
        else:
            errMsg = "Login to MML model failed, can not execute unrecovered alarms check.The reason of failure may be:\n" \
                    + "(1) Did not enter a developer password when adding the device.\n(2) The developer password entered is incorrect."
        # 设备登陆时输入developer密码无效 modified 20131130 End
        return (flag, "", errMsg) 
    
    #通过mml命令生成告警文件
    mmlRet = ssh.execCmd("alarm exportevent")
    
    ssh.execCmd("exit")
    ssh.execCmd("exit")
    ssh.execCmd("exit")

    if not bool(re.search("path", mmlRet, re.IGNORECASE)):
        flag = CheckedResult.WARN
        if lang == "zh":
            errMsg = u"当前版本不支持此操作，请通过登录ISM查看是否存在未恢复告警。"
        else:
            errMsg = "\nThe operation is not supported, please check the unrecovered alarm by ISM."
        return (flag, mmlRet, errMsg)
    
    remoteFile = getPath(unicode(mmlRet))
    
    #获取数据解压临时文件夹
    collectTmpDir = compressionManager.getCollectTmpDir(dataDict)
    
    #创建临时文件夹
    if not os.path.exists(collectTmpDir):
        os.makedirs(collectTmpDir)
    
    localFile = collectTmpDir + os.sep + 'event_export.tar'
    try:
        sftp.getFile(remoteFile, localFile, None)
    except Exception:
        flag = CheckedResult.WARN
        if lang == "zh":
            errMsg += u"\n告警文件" + remoteFile + u"不存在，请通过登录ISM查看是否存在未恢复告警。"
        else:
            errMsg += "\nAlarm file " + remoteFile + " does not exist, please check the unrecovered alarm by ISM."
        return (flag, mmlRet, errMsg)
    finally:
        if remoteFile:
            compressionManager.deleteRemoteFile(dataDict, remoteFile)
        
    decompressPKG(collectTmpDir + os.sep + 'event_export.tar', collectTmpDir)
    #打开告警文件
    try:
        alarmFile = open(collectTmpDir + os.sep + 'local_alm_file.txt', "r")
    except IOError:
        flag = CheckedResult.WARN
        if lang == "zh":
            errMsg += u"\n当前版本不支持此操作，请通过登录ISM查看是否存在未恢复告警。"
        else:
            errMsg += "\nThe operation is not supported, please check the unrecovered alarm by ISM."

        return (flag, mmlRet, errMsg)

    alarmIDs = []
    cliRet = "Raised  Local Time    Alarm ID    Alarm Level    Recovered Local Time    Description\n"
    for line in alarmFile:
        if line.find("Event list") >= 0:
            break
        
        list = line.split()
        if len(list) < 5:
            continue
        if list[4] != "None":
            continue
        #P12V-2721  未恢复告警级别检查优化 modified 20130509 Begin
        if list[3] not in ("Major", "Critical", "Warning", "Minor"):
            continue
        #P12V-2721  未恢复告警级别检查优化 modified 20130509 End
        
        flag = CheckedResult.NOTPASS
        # 将Suggestion字段之前的字符串添加到原始信息cliRet中。
        index = line.find("Step 1")
        cliRet += line[0:index]
        cliRet += "\n"

        alarmIDs.append(list[2])
    alarmFile.close()
    
    if flag == CheckedResult.NOTPASS:
        if lang == "zh":
            errMsg += u"\n存在以下未恢复告警: " + unicode(alarmIDs).replace("[", "").replace("]", "") + u"。"
        else:
            errMsg += "\nThere are unrecovered alarms: " + unicode(alarmIDs).replace("[", "").replace("]", "") + "."
    else:
        cliRet = mmlRet
    
    return (flag, cliRet, errMsg)

#P12V-2830 安全红线前未恢复告警检查 added 20130605 End
#P12V-2935 安全红线前检查未恢复告警处理优化 modified 20130731 End
