# -*- coding: UTF-8 -*-
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger
from common.sysInfoManager import isDoubleCtrlsModel

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Write Cache Utility
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''

    flag = CheckedResult.PASS
    errMsg = ""
    lang = getLang(dataDict) 
   
    cliRet = getCliRet(dataDict, "showcache")
    list = cliRet.splitlines()
    if len(list) < 7:
        #小于7行，Cli信息无效
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\nCli信息无效。"
        else:
            errMsg = "\nCli information invalid."          
        return (flag, cliRet, errMsg)
    
    #获取所有控制器Cache写利用率
    writeCacheUtiDict = {}
    controllerId = ""
    writeCacheUti = ""
    highWaterLevel = ""
    lowWaterLevel = ""
    avgWaterLevel = 0

    for field in list:
        list2 = field.split("|")
        if len(list2) == 2:
            if re.search("Controller ID", field, re.IGNORECASE):
                controllerId = list2[1].strip()
            elif re.search("High Water Level", field, re.IGNORECASE):
                highWaterLevel = list2[1].strip()
            elif re.search("Low Water Level", field, re.IGNORECASE):
                lowWaterLevel = list2[1].strip()
            elif re.search("Write Cache Utility", field, re.IGNORECASE):
                writeCacheUti = list2[1].strip()
                if controllerId != "":
                    writeCacheUtiDict[controllerId] = writeCacheUti
                    #初始化变量
                    controllerId = ""
                    writeCacheUti = ""
        else:
            continue
    #得到当前需要检查控制器的个数
    if isDoubleCtrlsModel(dataDict):
        controllerSize = 2
    else:
        controllerSize =1
    #获取信息失败
    if highWaterLevel == "" or lowWaterLevel == "" or len(writeCacheUtiDict) != controllerSize:
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"\n获取Cache信息失败。"
        else:
            errMsg = "\nGetting Cache data failed."          
        return (flag, cliRet, errMsg)
    
    #查看写利用率是否大于90%
    try:
        for key in writeCacheUtiDict:
            #当前写利用率高于90%，检查不通过
            if  int(writeCacheUtiDict[key]) > 90:
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg += u"\n控制器" + key + u"的Cache写利用率过高（" + unicode(writeCacheUtiDict[key]) + u"）。"
                else:
                    errMsg += "\nThe Write Cache Utility of controller " + key + " is too high (" + unicode(writeCacheUtiDict[key]) + ")."
    except:
        flag = CheckedResult.NOTPASS
        if lang == "zh":
            errMsg = u"Cli信息异常。"
        else:
            errMsg = "\nThe cli information is abnormal."        
    
    #检查结果返回
    return (flag, cliRet, errMsg)
