# -*- coding: UTF-8 -*-

import os 
from common import compressionManager
from common.contextUtil import getLang, getLogger
from common.constant import CheckedResult

def execute(context):
    '''
    @summary      : the entrance of main method, delete temporary files after evaluation
    @param context: context
    @return       : flag, cliRet, errMsg
    '''
    cliRet = ''
    errMsg = ''
    flag = CheckedResult.PASS
    lang = getLang(context)
    logger = getLogger(context)

    #1、获取临时目录，判断是否存在，不存在时返回通过，不显示; 存在时，进行删除
    collectTmpDir = compressionManager.getCollectTmpDir(context)
    if not os.path.exists(collectTmpDir):
        logger.error("Temporary files are not exist or cannot find Temporary files.")
        return (flag, cliRet, errMsg)
    else:
        compressionManager.deleteCollectTmpDir(context)
    
    #2、判断是否删除成功，删除成功通过，不显示；删除不成功，警告
    if os.path.exists(collectTmpDir):
        flag = CheckedResult.WARN
        if lang == "zh":
            errMsg = u"【说明】清理升级评估环境不会对升级评估结果产生影响。\n"\
                   + u"工具运行过程中在本地产生的临时文件部分清除失败，原因可能为文件路径过长等。\n"\
                   + u"请手动清除临时目录:%s。" % collectTmpDir
        else:
            errMsg = "[Note] Clearing the upgrade evaluation environment does not affect the upgrade evaluation result.\n"\
                   + "Failed to clear some local temporary files generated during tool operation. The possible cause is that the file path is too long.\n"\
                   + "Please manually clear temporary directory:%s." % collectTmpDir
        return (flag, cliRet, errMsg)
    
    return (flag, cliRet, errMsg)
    