# -*- coding: UTF-8 -*-

import time
from common.constant import CheckedResult
from common.contextUtil import getPdtVer,getLang,getLogger,getLoginUserName,getDevIp,getExtraDataDict,getDeveloperPwd,getDestVer,getDevType,getUpgradeModel,getCurSysVer,getDevSN
from common.sysInfoManager import getCurSystemVersion,switchValidVersion,switchDeviceType
from common.cmdRetManager import getCliRet
import defusedxml.ElementTree as ET
import re
import os
import sys
reload(sys)
sys.setdefaultencoding('utf8')
import java.lang.Exception as JException


PROGRESS_NUM_1 = 1
PROGRESS_NUM_5 = 5
PROGRESS_NUM_10 = 10
PROGRESS_NUM_15 = 15
PROGRESS_NUM_20 = 20
PROGRESS_NUM_40 = 40
PROGRESS_NUM_60 = 60
PROGRESS_NUM_80 = 80
PROGRESS_NUM_MAX = 100


def execute(context):
    '''
    @summary      : the entrance of main method, check sth before evaluation
    @param context: context
    @return       : flag, cliRet, errMsg
    '''
    flag = CheckedResult.PASS
    cliRet = ''
    errMsg = ''
    lang = getLang(context)
    logger = getLogger(context)
    item = "pre_check"
    try:
        getCliRet(context, 'chgpagination off')

        #保存时间戳信息
        creatAndSaveTimeStamp(context)

        #保存规范化后的当前系统版本信息（或称产品版本信息）
        getExtraDataDict(context)['curSysVer'] = switchValidVersion(getPdtVer(context))

        flagLst = []
        errMsgLst = []
        #检查设备状态
        flag, errMsg = isDeviceNormal(context)
        if CheckedResult.NOTPASS == flag:
            logger.error('check if the device is normal!')
            return (flag, cliRet, errMsg)
        setProgress(context, PROGRESS_NUM_10, item)
        funFlag, funErrMsg = isAdminUser(context)
        flagLst.append(funFlag)
        if CheckedResult.NOTPASS == funFlag:
            errMsgLst+=funErrMsg
            logger.error('check if it is admin user failed!')
        setProgress(context, PROGRESS_NUM_20, item)

        funFlag, funErrMsg = hasDeveloperPass(context)
        flagLst.append(funFlag)
        if CheckedResult.NOTPASS == funFlag:
            errMsgLst+=funErrMsg
            logger.error('check if it has developer password failed!')
        funFlag, funErrMsg = isDeviceVerValid(context)
        setProgress(context, PROGRESS_NUM_40, item)
        flagLst.append(funFlag)
        if CheckedResult.NOTPASS == funFlag:
            errMsgLst+=funErrMsg
            logger.error('check if device version is valid failed!')
        funFlag, funErrMsg = isVersionValid(context)
        setProgress(context, PROGRESS_NUM_60, item)
        flagLst.append(funFlag)
        if CheckedResult.NOTPASS == funFlag:
            errMsgLst+=funErrMsg
            logger.error('check if destination version is valid failed!')
        funFlag, funErrMsg = isVersionLimit(context)
        setProgress(context, PROGRESS_NUM_80, item)
        flagLst.append(funFlag)
        if CheckedResult.NOTPASS == funFlag:
            errMsgLst+=funErrMsg
            logger.error('check if destination version is limited failed!')
        if CheckedResult.NOTPASS in flagLst:
            flag = CheckedResult.NOTPASS

        for index in range(len(errMsgLst)):
            if lang == "zh":
                errMsg += u"【问题%s】:\n%s\n\n" %(index+1,errMsgLst[index])
            else:
                errMsg += "[Problem %s]:\n%s\n\n" %(index+1,errMsgLst[index])

        return flag,cliRet,errMsg

    finally:
        setProgress(context, PROGRESS_NUM_MAX, item)

def isDeviceNormal(context):
    '''
    @summary: judge whether the device status is normal
    @param context: the context object provided by tool framework
    @return: the status of device which is normal or abnormal, as boolean
    '''
    funFlag = CheckedResult.PASS
    funErrMsg = ''
    
    log = getLogger(context)
    systemInfo = getCliRet(context, 'showsys')
    pattern = '\s*Current System Mode\s*\|(.*)'
    ret4Search = re.search(pattern, systemInfo, re.IGNORECASE)
    sysStatus = ''
    if ret4Search:
        sysStatus = ret4Search.group(1).strip()
    
    #系统状态异常
    if not sysStatus or -1 == sysStatus.lower().find(' normal'):
        funFlag = CheckedResult.NOTPASS
        log.error('[pre_check]System status is not normal.')
        lang = getLang(context)
        if lang == 'zh':
            funErrMsg = u'系统状态异常。'
        else:
            funErrMsg = 'The system is abnormal.'
    
    return (funFlag, funErrMsg)


def isDeviceVerValid(context):
    '''
    @Function name      : isDeviceVerValid
    @Function describe  : 判断上下文中的版本信息是否有效
    @Input              : context
    @Return             : funFlag,funRet,funErrMsg
    '''
    funFlag = CheckedResult.NOTPASS
    funErrMsg = []
    
    #从上下文中获取当前版本并转化为标准格式
    curVersion = getCurSysVer(context)
    #从设备上获取当前版本
    deviceVersion = ''
    lang = getLang(context)
    
    retVersion = getCurSystemVersion(context)
    if not retVersion[0]:
        if lang == "zh":
            funErrMsg.append(u"获取设备版本信息失败。")
        else:
            funErrMsg.append("Failed to get the device version.")
        return funFlag, funErrMsg
    
    deviceVersion = retVersion[1]
    if curVersion == deviceVersion:
        funFlag = CheckedResult.PASS
        getExtraDataDict(context)['curSysVer'] = curVersion 
        getExtraDataDict(context)['cliRet4UpgradePkgInfo'] = retVersion[2]
    else:
        if lang == "zh":
            funErrMsg.append(u"设备当前版本为%s,工具保存的设备版本为%s,请关闭当前子工具并在工具设备管理界面重新添加或更新设备。" %(deviceVersion,curVersion))
        else:
            funErrMsg.append("The current version of the device is %s but that in the tool is %s. Close the current subtool and add the device again or refresh the device in the device management interface of the tool." %(deviceVersion,curVersion))
    return funFlag, funErrMsg

def isAdminUser(context):
    '''
    @Function name      : isAdminUser
    @Function describe  : 判断是否是admin用户登录
    @Input              : context
    @Return             : funFlag,funRet,funErrMsg
    '''
    funFlag = CheckedResult.NOTPASS
    funErrMsg = []
    
    loginUser = getLoginUserName(context)
    if  'admin' == loginUser:
        funFlag = CheckedResult.PASS
    else:
        lang = getLang(context)
        if lang == "zh":
            funErrMsg.append(u"当前登录用户不为admin，请使用admin用户重新登录。")
        else:
            funErrMsg.append("The current user is not admin. Log in as user admin.")
            
    return funFlag, funErrMsg
    
def creatAndSaveTimeStamp(context):
    '''
    @Function name      : creatAndSaveTimeStamp
    @Function describe  : 创建本执行流程的ip+时间戳信息
    @Input              : context
    @Return             : 
    '''
    curTime = time.strftime('%Y%m%d%H%M%S',time.localtime(time.time()))
    deviceIp = getDevIp(context)
    deviceSN = getDevSN(context)
    
    timeStamp = deviceSN +"_" + curTime
    getExtraDataDict(context)['timeStamp'] = timeStamp 
    return

def hasDeveloperPass(context):
    '''
    @Function name      : isAdminUser
    @Function describe  : 判断是否有developer密码
    @Input              : context
    @Return             : funFlag,funErrMsg,devType
    '''
    funFlag = CheckedResult.NOTPASS
    funErrMsg = []
    
    developerPass = getDeveloperPwd(context)
    if developerPass:
        funFlag = CheckedResult.PASS
    else:
        lang = getLang(context)
        if lang == "zh":
            funErrMsg.append(u"添加设备时，未输入调试密码，请输入正确的调试密码后重试。")
        else:
            funErrMsg.append("Debug password was not entered when adding the device. Please enter the correct debug password and try again.")
            
    return funFlag, funErrMsg

def isVersionValid(context):
    '''
    @Function name      : isVersionValid
    @Function describe  : 判断版本是否有效
    @Input              : context
    @Return             : funFlag,funErrMsg,devType
    '''
    ALL_VERSION_RANGE_STR = '''V100R001C00: SPC001 ~ SPC018 \n\
V100R001C01: SPC009 ~ SPC015 \n\
V100R002C00: SPC001 ~ Current Releasing Version  \n\
V100R002C01: SPC001 ~ Current Releasing Version  \n\
V100R005C00: SPC001 ~ Current Releasing Version \n\
V100R005C01: SPC700 ~ Current Releasing Version \n\
V100R005C02: V100R005C02 ~ Current Releasing Version \n\
V100R005C30: V100R005C30 ~ Current Releasing Version'''
    
    funFlag = CheckedResult.PASS
    funErrMsg = []
    #源版本
    curVer=getCurSysVer(context)
    #目标版本
    destVer=getDestVer(context)
    #语言环境
    lang = getLang(context)
        
    #向框架提需求，目标版本不能为空
    #有效性检查（1）：输入的当前版本号不能为空  
    if not destVer:
        funFlag = CheckedResult.NOTPASS
        if lang == "zh":
            funErrMsg.append(u"升级目标版本号为空，不能执行检查，请重新输入。")
        else:
            funErrMsg.append("The target version is left empty and the upgrade evaluation cannot be performed. Enter a target version. ")
           
    #有效性检查（2）：判断输入版本号是否在发布版本范围中
    dstVerFlag = checkInputVersionInRange(destVer)
    if not dstVerFlag:
        funFlag = CheckedResult.NOTPASS
        if lang == "zh":
            funErrMsg.append(u"目标版本号超出发布版本号范围，请参照如下范围进行输入：\n"+ ALL_VERSION_RANGE_STR)
        else:
            funErrMsg.append("The target version is out of range. Enter a target version in the following range:\n"+ ALL_VERSION_RANGE_STR)
    
    #有效性检查（3）：当前版本号与目标版本号不允许相同
    if curVer == destVer:
        funFlag = CheckedResult.NOTPASS
        if lang == "zh":
            funErrMsg.append(u"当前版本与目标版本相同，不能执行评估，请重新输入。")
        else:
            funErrMsg.append("The target version is the same as the source version, the upgrade assessment cannot be performed.")
    
    #有效性检查（4）：判断是否支持C版本升级
    #获取R版本和C版本信息
    curCVersionTmp = curVer[0:11]
    upgCVersionTmp = destVer[0:11]
    #TR5可能为空
    curSPCVersionTmp = curVer[11:]
    upgSPCVersionTmp = destVer[11:]
    
    #不允许的C版本间升级
    cVerUpgradeLimit = False
    #V1R1C00/V1R1C01不能够升级到V1R2C01和V1R5C01 
    if curCVersionTmp in ("V100R001C00", "V100R001C01") and upgCVersionTmp in ("V100R002C01", "V100R005C01"):
        funFlag = CheckedResult.NOTPASS
        cVerUpgradeLimit = True
    
    #V1R2C00不能升级到V1R2C01 /V1R5C01
    elif curCVersionTmp in ("V100R002C00") and upgCVersionTmp in ("V100R005C01","V100R002C01"):
        funFlag = CheckedResult.NOTPASS
        cVerUpgradeLimit = True
        
    #V1R2C01 不能升级到V1R5C00SPC500后        
    elif curCVersionTmp in ("V100R002C01") and upgCVersionTmp in ("V100R005C00"):
        if destVer > "V100R005C00SPC500":
            funFlag = CheckedResult.NOTPASS
            cVerUpgradeLimit = True
                        
    #V1R5C00SPC500后不能升级到V1R5C01
    elif curCVersionTmp == "V100R005C00" and upgCVersionTmp in ("V100R005C01"):
        if curVer > "V100R005C00SPC500":
            funFlag = CheckedResult.NOTPASS
            cVerUpgradeLimit = True
    if cVerUpgradeLimit:
        if lang == "zh":
            funErrMsg.append(u"不支持版本升级，请重新输入。")
        else:
            funErrMsg.append("The target version is not supported, enter another one.")
            
    #有效性检查（5）：判断是否为回退
    #非回退检查
    rollbackFlag = False        
    #当前C版本大于目标C版本则提示不支持回退检查
    if curCVersionTmp > upgCVersionTmp:
        funFlag = CheckedResult.NOTPASS
        rollbackFlag = True
    #C版本相同
    elif curCVersionTmp == upgCVersionTmp:
        #当前SPC号大于目标SPC号则提示不支持回退检查
        if curSPCVersionTmp > upgSPCVersionTmp:
            funFlag = CheckedResult.NOTPASS
            rollbackFlag = True
    if rollbackFlag:
        if lang == "zh":
            funErrMsg.append(u"工具只支持版本间升级的评估，不支持版本间回退的评估。")
        else:
            funErrMsg.append("The tool supports the assessment for version upgrade only. The rollback between versions cannot be assessed.")
    return funFlag, funErrMsg

def isVersionLimit(context):
    '''
    @Function name      : filterVersionLimit(checklist)
    @Function describe  : 根据版本受限过滤checklist
    @Input              : checklist
    @Return             : checklist
    '''
    funFlag = CheckedResult.PASS
    funErrMsg = []
    lang = getLang(context)
    #源版本
    curVer=getCurSysVer(context)
    #目标版本
    destVer=getDestVer(context)
    #设备型号
    devModel=getDevType(context)
    #升级模式
    upgradeMode=getUpgradeModel(context)
    
    limitDeviceType = ""
    limitCurVerCon = ""
    limitCurVerLogic = ""
    limitDstVerCon = ""
    limitDstVerLogic = ""
    deviceType=switchDeviceType(devModel)
    ProductVersion = curVer[0:11]
    CONFIG_LIMIT_FILE_NAME = r"packages\UpgradeEvaluation\products\S5000TV100\version_limit.xml"
    root = ET.parse(os.getcwd() + os.sep + CONFIG_LIMIT_FILE_NAME)
    resourceDict = parseDesc(lang)
    for type_node in root.getiterator("Type"):
        if type_node.attrib['ProductVersion'] == ProductVersion:
            for upg_node in type_node.getchildren():
                for node in upg_node.getchildren():
                    if node.tag == "CurVer":
                        limitCurVerLogic = node.attrib["Logic"]
                        limitCurVerCon = node.text
                    if node.tag == "DstVer":
                        limitDstVerLogic = node.attrib["Logic"]
                        limitDstVerCon = node.text
                    if node.tag == "DeviceType":
                        limitDeviceType = node.text
                    if node.tag == "UpgradeModel":
                        LimitUpgradeModel = node.text
                    if node.tag == "Description":
                        LimitDesc = resourceDict[unicode(node.text)]
                    if node.tag == "Suggestion":
                        LimitSuggest = resourceDict[unicode(node.text)]
                #查询产品型号是否满足
                if limitDeviceType != "ALL" and limitDeviceType != deviceType:
                    continue
                #查询升级方式是否满足
                if LimitUpgradeModel != "ALL" and LimitUpgradeModel.lower() != upgradeMode.lower():
                    continue
                #查询源版本是否满足
                if not isVerInRange(limitCurVerLogic,curVer,limitCurVerCon):
                    continue
                #查询目标版本是否满足
                if not isVerInRange(limitDstVerLogic,destVer,limitDstVerCon):
                    continue
                funFlag = CheckedResult.NOTPASS
                if lang == 'zh':
                    funErrMsg.append(u"原因：%s\n建议：%s" %(LimitDesc,LimitSuggest))
                else:
                    funErrMsg.append("Reason:%s\nSuggestion:%s" %(LimitDesc,LimitSuggest))
                
    return funFlag, funErrMsg

def parseDesc(lang):
    '''
    @Function name      : parseDesc
    @Function describe  : 解析资源文件
    @Input              : lang
    @Return             : resourceDict
    '''
    resourceDict = {}
    configFileName = ''
    CONFIG_ZH_FILE_NAME = r"packages\UpgradeEvaluation\products\S5000TV100\res\resource_zh.ini"
    CONFIG_EN_FILE_NAME = r"packages\UpgradeEvaluation\products\S5000TV100\res\resource_en.ini"

    if lang == 'zh':
        configFileName = CONFIG_ZH_FILE_NAME
    else:
        configFileName = CONFIG_EN_FILE_NAME
    
    #取得配置文件的绝对路径
    filepath = os.getcwd()
    filename = filepath + os.sep + configFileName
    
    configfile = open(filename)
    
    for line in configfile:

        if not bool(re.search("=", line, re.IGNORECASE)):
            continue
        field = line.replace('\n', '').split('=')

        resourceID = (field[0]).decode('UTF-8')
        resourceDes = (field[1]).decode('UTF-8')
        resourceDict[resourceID] = resourceDes
        
    configfile.close()
    return resourceDict

def isVerInRange(limitVerLogic,ver,limitVerCon):
    '''
    @Function name      : isVerInRange
    @Function describe  : 判断版本是都在范围内
    @Input              : limitVerLogic,ver,limitVerCon
    @Return             : True/False
    '''
    #如果Logic为ALL，则认为所有版本均满足
    if limitVerLogic == "ALL":
        return True
    elif ver[0:11] == limitVerCon[0:11]:
        if limitVerLogic == "Equal" and re.search(ver, limitVerCon, re.IGNORECASE):
            return True
        elif limitVerLogic == "Great" and ver > limitVerCon:
            return True
        elif limitVerLogic == "Less" and ver < limitVerCon:
            return True
        elif limitVerLogic == "GreatEqual" and ver >= limitVerCon:
            return True
        elif limitVerLogic == "LessEqual" and ver <= limitVerCon:
            return True
        elif limitVerLogic == "Range":
            field = limitVerCon.split(",")
            if len(field) == 2:
                RangeVerMin = field[0]
                RangeVerMax = field[1]
                if ver >= RangeVerMin and ver <= RangeVerMax:
                    return True
        else:
            return False
    else:
        return False
    
    
def checkInputVersionInRange(version):
    '''
    @Function name      : checkInputVersionInRange
    @Function describe  : 判断版本是否有效范围内
    @Input              : version
    @Return             : True/False
    '''
    '''各个R版本的发布版本号范围'''
    V1R1C00_VERSION_RANGE = ['SPC001', 'SPC018']
    V1R1C01_VERSION_RANGE = ['SPC009', 'SPC015']
    V1R2C00_VERSION_RANGE = ['SPC001', '']
    V1R2C01_VERSION_RANGE = ['SPC001', '']
    V1R5C00_VERSION_RANGE = ['SPC001', '']
    V1R5C01_VERSION_RANGE = ['SPC700', '']
    V1R5C02_VERSION_RANGE = ['SPC000', '']
    V1R5C30_VERSION_RANGE = ['SPC000', '']
    
    "初始化检查信息"
    checkVersion = ''
    checkRange =[]
    rangeMinVersion = ''
    rangeMaxVersion = ''
    
    '''通过版本号的R版本来获取check信息'''
    if version.startswith('V100R001C00'):
        checkVersion = version.replace('V100R001C00', '')
        checkRange = V1R1C00_VERSION_RANGE
    elif version.startswith('V100R001C01'):
        checkVersion = version.replace('V100R001C01', '')
        checkRange = V1R1C01_VERSION_RANGE
    elif version.startswith('V100R002C00'):
        checkVersion = version.replace('V100R002C00', '')
        checkRange = V1R2C00_VERSION_RANGE
    elif version.startswith('V100R002C01'):
        checkVersion = version.replace('V100R002C01', '')
        checkRange = V1R2C01_VERSION_RANGE 
    elif version.startswith('V100R005C00'):
        checkVersion = version.replace('V100R005C00', '')
        checkRange = V1R5C00_VERSION_RANGE
    elif version.startswith('V100R005C01'):
        checkVersion = version.replace('V100R005C01', '')
        checkRange = V1R5C01_VERSION_RANGE
    elif version.startswith('V100R005C02'):
        checkVersion = version.replace('V100R005C02', '')
        checkRange = V1R5C02_VERSION_RANGE
    elif version.startswith('V100R005C30'):
        checkVersion = version.replace('V100R005C30', '')
        checkRange = V1R5C30_VERSION_RANGE
    else:
        return False
    '''判断输入版本号是否在Range内'''
    rangeMinVersion = checkRange[0]
    rangeMaxVersion = checkRange[1]
    
    if rangeMinVersion != '' and checkVersion < rangeMinVersion:
        return False
    if rangeMaxVersion != '' and checkVersion > rangeMaxVersion:
        return False

    return True


def setProgress(context, progress, item):
    try:
        observer = context.get("progressObserver")
        if observer != None:
            observer.updateItemProgress(context.get("dev"), int(progress), item)
    except (JException, Exception), exption:
        pass
