# -*- coding: UTF-8 -*-
from contextUtil import getSshObj, getLogger


def execCmd(context, cmd):
    '''
    @summary: execute command
    @param context: the context object provided by tool framework
    @param cmd: the command which need to send
    @return: the result of the command response information
    '''
    ssh = getSshObj(context)
    logger = getLogger(context)
    ret4cmd = ssh.execCmd(cmd)
    logger.info('[cmdManager]Execute command [%s] successfully.' % cmd)
    return ret4cmd


def execCmdNoLog(context, cmd):
    '''
    @summary: execute command but no log
    @param context: the context object provided by tool framework
    @param cmd: the command which need to send
    @return: the result of the command response information
    '''
    ssh = getSshObj(context)
    logger = getLogger(context)
    ret4cmd = ssh.execCmdNoLog(cmd)
    cmd = '******'#涉及不需要打印的命令将其替换为*
    logger.info('[cmdManager]Execute command [%s] no log successfully.' % cmd)
    return ret4cmd


def execCmdNoLogTimout(context, cmd, timeout):
    '''
    @summary: execute command
    @param context: the context object provided by tool framework
    @param cmd: the command which need to send
    @param timeout: timeout, count via seconds
    @return: the result of the command response information
    '''
    ssh = getSshObj(context)
    logger = getLogger(context)
    ret4cmd = ssh.execCmdNoLogTimout(cmd, timeout)
    cmd = '******'#涉及不需要打印的命令将其替换为*
    logger.info('[cmdManager]Execute command [%s] no log with timeout(%ss) successfully.' % (cmd, timeout))
    return ret4cmd


def execCmdWithTimout(context, cmd, timeout):
    '''
    @summary: execute command with timeout
    @param context: the context object provided by tool framework
    @param cmd: the command which need to send
    @param timeout: timeout, count via seconds
    @return: the result of the command response information
    '''
    ssh = getSshObj(context)
    logger = getLogger(context)
    ret4cmd = ssh.execCmdWithTimout(cmd, timeout)
    logger.info('[cmdManager]Execute command [%s] with timeout(%ss) successfully.' % (cmd, timeout))
    return ret4cmd


def execCmdWithOutReturn(context, cmd):
    '''
    @summary: execute command without returning information
    @param context: the context object provided by tool framework
    @param cmd: the command which need to send
    '''
    ssh = getSshObj(context)
    logger = getLogger(context)
    ssh.execCmdWithOutReturn(cmd)
    logger.info('[cmdManager]Execute command [%s] without return information successfully.' % cmd)
    return

