# -*- coding: UTF-8 -*-
'''
模块说明：该模块各个方法主要是从工具框架提供的上下文环境（context）获取相关信息；
注意：分割线“---”以上为工具框架提供，分割线以下为脚本侧存入上下文环境（context）的数据获取方式
'''

import re


def getLogger(context):
    '''
    @summary: 获取日志打印对象
    '''
    return context.get('logger')


def getLang(context):
    '''
    @summary: 获取工具语言环境
    '''
    return context.get('lang')


def getSshObj(context):
    '''
    @summary: 获取工具与阵列的SSH连接对象，该对象包含上传、下载、判断文件是否存在、罗列文件夹数据等方法
    '''
    return context.get('ssh')


def getSftpObj(context):
    '''
    @summary: 获取工具与阵列的SFTP连接对象
    '''
    return context.get('sftp')


def getTlvObj(context):
    '''
    @summary: 获取工具与阵列的TLV连接对象
    '''
    return context.get('tlv')


def getDevObj(context):
    '''
    @summary: 获取设备节点信息对象，该对象包含设备型号、设备版本号、设备SN、设备ip、用户名、密码等信息
    '''
    return context.get('dev')


def getDevName(context):
    '''
    @summary: 获取设备名称
    '''
    return getDevObj(context).getDeviceName()


def getDevSN(context):
    '''
    @summary: 获取设备序列号Serial Number
    '''
    return getDevObj(context).getDeviceSerialNumber()


def getDevType(context):
    '''
    @summary: 获取设备类型
    '''
    return getDevObj(context).getDeviceModel()


def getDevIp(context):
    '''
    @summary: 获取设备当前控制器IP
    '''
    return getDevObj(context).getIp()


def getDevPeerIp(context):
    '''
    @summary: 获取设备对端控制器IP
    '''
    return getDevObj(context).getPeerIp()


def getDevPort(context):
    '''
    @summary: 获取设备端口
    '''
    return unicode(getDevObj(context).getPort())


def getLoginUserName(context):
    '''
    @summary: 获取登录用户名
    '''
    return getDevObj(context).getLoginUser().getUserName()


def getDeveloperPwd(context):
    '''
    @summary: 获取developer密码
    '''
    return getDevObj(context).getDeveloperPwd()


def getPdtVer(context):
    '''
    @summary: 获取产品版本
    @note: 对于TV1产品，该方式获取的信息可能不规范，请使用getCurSysVer方法提供的设备版本
    @see: getCurSysVer
    '''
    return getDevObj(context).getProductVersion()


def getDestVer(context):
    '''
    @summary: 获取升级目标版本号
    '''
    return getDevObj(context).getDestVersion()


def getUpgradeModel(context):
    '''
    @summary: 获取升级模式（在线或者离线），其值为“ONLINE”或“OFFLINE”
    '''
    return unicode(getDevObj(context).getUpgradeMode())


def getCheckModel(context):
    '''
    @summary: 获取检查方式（联机、脱机），其值为“LINK”和“UNLINK”
    '''
    return unicode(context.get('evaluMode'))


def getPackMgr(context):
    '''
    @summary: 获取包管理器，该对象主要提供压缩解压方法
    @detail: 1.解压方法（带密码，尝试多个密码）： deCompressPackage(String pkgPath, String[] pwds)
    @detail: 2.压缩方法：String compressPackage(String collectPath)
    @note: dataCollectFile和collectPath涉及的路径都是绝对路径
    '''
    return context.get('collectManagement')


def getTmpDir(context):
    '''
    @summary: 获取子工具运行根目录下的临时目录
    '''
    return context.get('tmpDir')


def getExtraDataDict(context):
    '''
    @summary: 获取额外数据字典，主要用于存放脚本执行时的临时数据
    '''
    return context.get('extraMap')


#--------------------------------------------------优雅的分割线---------------------------------------------------------
'''注意：分割线以下的方法均为py脚本存入上下文环境context的相关信息获取入口'''


def getTimeStamp(context):
    '''
    @summary: 获取在pre_check.py中存入的时间戳
    '''
    return getExtraDataDict(context).get('timeStamp')


def getCurSysVer(context):
    '''
    @summary: 获取在pre_check.py中存入的当前系统的版本号，即规范化后的产品版本号
    @note: 其与getPdtVer的区别在于:getPdtVer为框架从CLI信息里获取的原始系统版本信息，而该方法将前者是经过转换得到，因为部分产品版本显示不规范
    @example: 例如某些产品的系统版本型号为“S2600TV100R002C01SPC006”，需要转换为规范的格式“TV100R002C01SPC006”
    @usage: 具体用法为：在具体检查项调用前在pre_check.py中将转换后的值存入上下文环境，而转换方式为调用switchValidVersion方法将获取到的原始值进行转换
    @see: getPdtVer
    '''
    return getExtraDataDict(context).get('curSysVer')


def getCliRet4UpgradePkgInfo(context):
    '''
    @summary: 获取升级包CLI回显信息，对于TV1产品其等同于命令“showupgradepkginfo -t 1”回显信息
    '''
    return getExtraDataDict(context).get('cliRet4UpgradePkgInfo')


def getCtrlIpAndIdMap(context):
    '''
    @summary: 获取控制器的IP和ID(即Name)的映射关系
    @param context: 上下文对象
    '''
    return getExtraDataDict(context).get('ctrlIpAndIdMap')