#coding: UTF-8

import re
from contextUtil import getLang, getSshObj, getDeveloperPwd, getLogger
from constant import Cli_Cmd


def changeCli2DeveloperWithErrMsg(dataDict):
    '''
    @summary: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
    '''
    errMsg = ""
    ssh = getSshObj(dataDict)
    lang = getLang(dataDict)
    devPasswd = getDeveloperPwd(dataDict)
    if not devPasswd:
        if "zh" == lang:
            errMsg = u"\n获取调试密码为空，请确定是否已配置调试密码。"
        else:
            errMsg = "\nThe debug password is blank. Please confirm that the debug password is set."
        return False, errMsg
    
    cliRet = ssh.execCmd(Cli_Cmd.SWITCH_TO_DEVELOPER)
    #判断是否已经developer模式
    for i in range(3):#密码错误 时需要重试三次
        if re.search("Password", cliRet, re.IGNORECASE):
            temp = ssh.execCmdNoLog(devPasswd)
            if re.search("developer", temp, re.IGNORECASE):
                return True, errMsg
    
    if "zh" == lang:
        errMsg = u"\n切换到developer模式失败，可能的原因是：当前用户不支持developer模式或调试密码输入错误。请按照如下建议处理：\
        \n（1）如果当前用户级别不是超级管理员或者管理员，请使用超级管理员或者管理员用户登录后重新执行检查；\
        \n（2）如果当前用户级别是超级管理员或者管理员，请检查调试密码是否正确输入，输入正确的调试密码后重新执行检查。"
    else:
        errMsg = u"\nFailed to switch to the developer mode. The reason of failure may be: Current user cannot switch to developer mode or the debug password entered is incorrect.\
        \n(1) If the current user level is not Super_admin or Admin, log in as Super_admin or Admin and perform check again. \
        \n(2) If the current user level is Super_admin or Admin, check whether the debug password is correct. Enter the correct debug password and perform check again."
    
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False,errMsg


def changeCli2DiagnoseWithErrMsg(context):
    '''
    @summary: 从CLI模式进入Diagnose模式，包含错误消息
    '''
    isSucc, errMsg = changeCli2DeveloperWithErrMsg(context)
    if not isSucc:
        return (isSucc, errMsg)
    
    ssh = getSshObj(context)
    devRet = ssh.execCmdWithTimout("debug", 10)
    if re.search('diagnose>', devRet, re.IGNORECASE):
        return (True, '')
   
    lang = getLang(context)
    if 'zh' == lang:
        errMsg = u'切换到diagnose模式失败。'
    else:
        errMsg = 'Failed to switch to the diagnose mode.'
    #进入diagnose模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return (False, errMsg)


def changeAnyModel2Cli(ssh):
    '''
    @summary: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
    '''
    counter = 0
    
    while True:
        temp = ssh.execCmdWithTimout("show system general", 180)
        
        #非developer模式下，cli回文正确，则认为回到了cli
        if re.search("System Name", temp, re.IGNORECASE) \
            and not re.search("developer:", temp, re.IGNORECASE):
                break
            
        #最小系统下要用exit会直接断开连接（也可能退出到admin模式，待确认）
        if re.search("minisystem", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                try:
                    ssh.execCmd("y")
                except:
                    ssh.reConnect()
        #os_only模式下直接退出
        elif re.search("-bash", temp, re.IGNORECASE):
            ssh.execCmdWithTimout("sh /ISM/cli/start.sh", 60)
            
        #其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("n")
                break
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 5:
            break


def changeCli2Developer(context):
    '''
    @summary: change mode from CLI to developer
    @param context: the dictionary of data which provided by tool framework
    @return: boolean value, True as success, False as failure 
    '''
    ssh = getSshObj(context)
    devPasswd = getDeveloperPwd(context)
    temp = ssh.execCmd(Cli_Cmd.SWITCH_TO_DEVELOPER)
    #判断是否已经developer模式
    if re.search("Password", temp, re.IGNORECASE):
        temp = ssh.execCmdNoLog(devPasswd)
        if re.search("developer", temp, re.IGNORECASE):
            return True
    
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False


def changeCli2Diagnose(context):
    '''
    @summary: change mode from CLI to diagnose
    @param context: the dictionary of data which provided by tool framework
    @return: boolean value, True as success, False as failure 
    '''
    if not changeCli2Developer(context):
        return False
    
    ssh = getSshObj(context)
    devRet = ssh.execCmdWithTimout("debug", 10)
    if re.search('diagnose>', devRet, re.IGNORECASE):
        return True
   
    #进入diagnose模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False