# -*- coding: UTF-8 -*-

import re
from cmdRetManager import getCliRet
from constant import DeviceType

def switchDeviceType(deviceType):
    '''
    @summary: 将设备类型转换成统一类型（S2600T、S3900、S6900）
    @param deviceType: the type of device
    @return: DeviceType
    '''
    #查询设备类型
    if deviceType in ["S2200T", "S2200T-S", "S2600T", "S2900"]:
        return DeviceType.S2900
    elif deviceType in ["S3900-M200", "S3900-M300", "S3900", "S5500T"]:
        return DeviceType.S3900
    elif deviceType in ["S5600T", "S5900-M100", "S5900-M200", "S5800T", "S6800T", "S6900-M100", "S8000-I", "S6900"]:
        return DeviceType.S6900
    else:
        return DeviceType.UNKNOWN
    
def getCurRealDeviceType(dataDict):
    '''
    @summary: 获取当前真实设备类型
    @param dataDict: the context object provided by tool framework
    @return: deviceType
    '''
    #查询设备类型
    deviceType = ""
    sysInfo = getCliRet(dataDict, "showsys")
    lineList = sysInfo.splitlines()
    if re.search("System Information", sysInfo, re.IGNORECASE):
        for line in lineList:
            if line.find("Device Type") != -1:
                field = line.split()
                if len(field) == 5:
                    deviceType = field[-1]
                break
    return (sysInfo, deviceType)
    
    
def getCurDeviceType(dataDict):
    '''
    @summary: 获取当前等价设备类型（S2600T、S3900、S6900）
    @param dataDict: the context object provided by tool framework
    @return: DeviceType
    '''
    sysInfo, DeviceType = getCurRealDeviceType(dataDict)
    #转换成统一的设备型号
    DeviceType = switchDeviceType(DeviceType)
    return (sysInfo, DeviceType)




def switchValidVersion(version):
    '''
    @summary: 将版本号转化成有效的版本号（17位：V200R002C00SPC100 或者11位：V200R002C02）
    @param version: the version of device
    @return: validVersion
    '''
    validVersion = ""
    
    startIndex = version.index("V200")
    if re.search("SPC", version, re.IGNORECASE):
        endIndex = startIndex + 17  #格式：V200R002C00SPC100
    else:
        endIndex = startIndex + 11  #格式：V200R002C02
    
    #提取有效的版本号信息
    validVersion = version[startIndex: endIndex]
    
    return validVersion


def getCurSystemVersion(dataDict):
    '''
    @summary: 获取当前系统SPC版本号
    @param dataDict: the context object provided by tool framework
    @return: flag, sysSpcVersion, sysVerInfo
    '''
    #查询系统版本号
    sysSpcVersion = ""
    sysVerInfo = getCliRet(dataDict, "show upgrade package")
    flag = False
    lines = sysVerInfo.splitlines()
    # 命令执行结果小于7行，说明执行该命令后并没有输出有效信息
    if len(lines) < 7:
        return (flag, "", sysVerInfo)

    # 从第7行开始，取出有效信息
    field = lines[5].split()
    sysSpcVersion = switchValidVersion(field[3])
    flag = True
    return (flag, sysSpcVersion, sysVerInfo)




