﻿# -*- coding: UTF-8 -*-
'''
模块说明：该模块为常用功能模块
'''
import re
import java.util.regex.Pattern as Jpattern
import datetime

CLI_RET_END_FLAG = ":/>"


def getCurDateAndTime(format=''):
    '''
    @summary: get current date and time
    @param format: the format of date or time, as string
    @return: date and time as string
    '''
    microSecond = unicode(datetime.datetime.now().microsecond)
    #默认为17位时间戳，即精确到毫秒
    DEFAULT_FORMAT = '%Y%m%d%H%M%S' + microSecond[:3]
    if not format:
        format = DEFAULT_FORMAT
    nowDateAndTime = datetime.datetime.now()
    strTime = nowDateAndTime.strftime(format)
    return strTime


def reverseDict(dict2BReversed):
    '''
    @summary: reverse dictionary
    @param dict2BReversed: dictionary which need to be reversed
    @return: dictionary which has been reversed
    '''
    return dict(map(lambda t:(t[1],t[0]), dict2BReversed.items()))

def getHorizontalCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = Jpattern.compile("^\s*-+(\s+-+)*\s*$") 
            match_headline = reg_headline.matcher(line)
            if match_headline.find():
                headline = match_headline.group(0)
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []
        
        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = Jpattern.compile("\s*-+\s*")
        match = reg_split.matcher(headline)
        tuple_idxs = []
        while(match.find()):
            tuple_idxs.append((match.start(), match.end()))
            
        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))
        
        requiredLineLen = tuple_idxs[-1][0]
        dictList = []
        for line in field_words:
            if CLI_RET_END_FLAG in line:
                break
            
            if line.strip().endswith(":"):
                break
            
            if len(line) <= requiredLineLen:
                break
            
            vals = []
            for item in tuple_idxs:
                vals.append(line[item[0]:item[1]].strip().decode("utf8"))
            dictList.append(dict(zip(keys, vals)))
            
        return dictList
    except:
        raise
