# -*- coding: UTF-8 -*-

import java.util.regex.Pattern as Jpattern

class Regex():
    IGNORECASE = Jpattern.CASE_INSENSITIVE
    VERBOSE = Jpattern.COMMENTS
    MULTILINE = Jpattern.MULTILINE
    DOTALL = Jpattern.DOTALL
    UNICODE = Jpattern.UNICODE_CASE
    
    @staticmethod
    def find(regex, s, flags=0, startPos=0):
        '''
        @summary: 返回正则表达式匹配是否成功
        @param regex: 正则表达式
        @param s: 要匹配的字符串
        @return: 
            True: 匹配成功
            False: 匹配失败
        '''
        reg = Jpattern.compile(regex, flags) 
        match = reg.matcher(s)
        if match.find(startPos):
            return True
        else:
            return False
    
    @staticmethod
    def search(regex, s, flags=0, startPos=0):
        '''
        @summary: 使用正则表达式匹配，返回匹配的结果
        @param regex: 正则表达式
        @param s: 要匹配的字符串
        @return: 匹配的结果
        '''
        reg = Jpattern.compile(regex, flags) 
        match = reg.matcher(s)
        if match.find(startPos):
            return match
        else:
            return None


class RegPattern():
    '''
    @summary: regular expression pattern
    '''
    IPV4 = '((\d{1}|[1-9]\d{1}|1\d{2}|2[0-4]\d|25[0-5])\.){3}(\d{1}|[1-9]\d{1}|1\d{2}|2[0-4]\d|25[0-5])'
    