# -*- coding: UTF-8 -*-
import traceback
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Controller Status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict, "show controller general")
        
        lines = cliRet.splitlines()
        i, j = 0, 0
        for field in lines:
            field = field.replace(" ", "")
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = CheckedResult.NOTPASS
                log.info("Sequence[controllerStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = CheckedResult.NOTPASS
                log.info("There is an error in Sequence[controllerStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:", "")
                continue
                        
            if field.startswith("HealthStatus"):
                healthStatus = field.replace("HealthStatus:", "")
                if healthStatus != "Normal":
                    flag = CheckedResult.NOTPASS
                    tuple2BReplaced = (ctrlId, healthStatus)
                    if "zh" == lang:
                        errMsg += u"\n控制器[%s]健康状态异常（%s）。" % tuple2BReplaced
                    else:
                        errMsg += "\nThe health status of Controller [%s] is abnormal(%s)." % tuple2BReplaced
                i = i + 1
                continue
                
            if field.startswith("RunningStatus"):
                runningStatus = field.replace("RunningStatus:", "")
                if runningStatus != "Online":
                    flag = CheckedResult.NOTPASS
                    tuple2BReplaced = (ctrlId, runningStatus)
                    if "zh" == lang:
                        errMsg += u"\n控制器[%s]运行状态异常（%s）。" % tuple2BReplaced
                    else:
                        errMsg += "\nThe running status of Controller [%s] is abnormal(%s)." % tuple2BReplaced
                j = j + 1
                continue
        
        # 安全模式没有查询到任何控制器信息，Modified 2013/12/09 Begin
        if 0 == i or 0 == j:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n系统状态可能不正常，没有查询到任何控制器信息。"
            else:
                errMsg += "\nSystem status may be abnormal, query no controller information."
        # 安全模式没有查询到任何控制器信息，Modified 2013/12/09 End
        elif i % 2 == 1 or j % 2 == 1:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\n可能存在离线的控制器。"
            else:
                errMsg += "\nThe controller of the system may be offline."

        return (flag, cliRet, errMsg)

    except Exception:
        log.error("Sequence[controllerStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
            
        return (flag, cliRet, errMsg)
