# -*- coding: UTF-8 -*-
import traceback
import re 
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger
from common.util import checkCliInfoValid, formatStr
from common.constant import CheckedResult


def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check disk health
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict, "show disk health", False)
        cmdRetList = cliRet.splitlines()
        #判断回显信息有效性
        if len(cmdRetList) < 5 and not re.search("Disk ID", cliRet, re.IGNORECASE) \
            and not re.search("Health Mark", cliRet, re.IGNORECASE):
            if not checkCliInfoValid(cliRet, False):
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = CheckedResult.PASS
            return (flag, cliRet, errMsg)
        
        formatedRet = formatStr(cliRet)
        formatedDictList = []
        #如果类型为字典则转换为列表
        if "dict" in unicode(type(formatedRet)):
            formatedDictList.append(formatedRet)
        else:
            formatedDictList = formatedRet
        # 磁盘健康度检查修改 modified 20131118 Begin
        for i in range(len(formatedDictList)):
            diskId = unicode(formatedDictList[i].get("Disk ID"))
            healthMask = unicode(formatedDictList[i].get("Health Mark"))
            # 硬盘健康度的检查标准不准确, 2013/12/02 Modified Begin
            tuple2Breplaced = (diskId, healthMask)
            if healthMask in ["255", "--"]:
                log.info("Sequence[DiskHealthDegree] diskId [%s] Health Mark is:%s" % tuple2Breplaced)
                continue
            # 硬盘健康度的检查标准不准确, 2013/12/02 Modified End
            
            #健康分值小于等于60，检查不通过
            if not healthMask or not healthMask.isdigit() or int(healthMask) <= 60:
                log.info("Sequence[DiskHealthDegree] Health Mark is:" + healthMask + "~~~over!")
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\n硬盘[%s]的健康状态不正常（%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe health mark of disk[%s] is abnormal(%s)." % tuple2Breplaced
        
        return (flag, cliRet, errMsg)
        # 磁盘健康度检查修改 modified 20131118 End
    except Exception:
        log.error("Sequence[DiskHealthDegree] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
            
        return (flag, cliRet, errMsg)
