# -*- coding: UTF-8 -*-
import traceback
import re
from common import util
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger,getSshObj

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check disk status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        allRet = ""
        filterCmd = "|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online"
        allRet = getCliRet(dataDict, "show disk general", False)
        cliRet = getCliRet(dataDict, "show disk general " + filterCmd)
        allRet += cliRet
        
        lines = cliRet.splitlines()
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = CheckedResult.NOTPASS
                log.info("Sequence[diskStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, allRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = CheckedResult.NOTPASS
                log.info("There is an error in Sequence[diskStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, allRet, errMsg)
       
        diskList = util.formatList(cliRet)
        for diskDict in diskList:
            flag = CheckedResult.NOTPASS
            diskId = diskDict.get("ID")
            healthStatus = diskDict.get("Health Status")
            runningStatus = diskDict.get("Running Status")
            tuple2Breplaced = (diskId, healthStatus, runningStatus)
            if "zh" == lang:
                errMsg += u"\n硬盘[%s]状态存在异常（Health Status：%s，Running Status：%s）。" % tuple2Breplaced
            else:
                errMsg += "\nThe status of disk[%s] is abnormal(Health Status: %s, Running Status: %s)." % tuple2Breplaced
    
        return (flag, allRet, errMsg)
    
    except Exception:
        log.error("Sequence[diskStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, allRet, errMsg)
