# -*- coding: UTF-8 -*-
import traceback
import re
from common import util
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger,getSshObj

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check pcie port status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        cliRet = ""
        errMsg = ""
        cliRet = getCliRet(dataDict, "show port general physical_type=PCIE")
                
        if not util.checkCliInfoValid(cliRet, False) :
            if lang == "zh":
                errMsg = u"\n无效CLI信息。"
            else:
                errMsg = "\nInvalid Cli information."
            return CheckedResult.NOTPASS, cliRet, errMsg
        
        pciePortList = util.formatList(cliRet)
        if not pciePortList:
            cliRetItem = getCliRet(dataDict, "show enclosure |filterRow column=Logic\sType predict=equal_to value=Engine")
            if not util.checkCliInfoValid(cliRetItem, True) :
                if lang == "zh":
                    errMsg = u"\n查询控制框数量失败。"
                else:
                    errMsg = "\nFailed to query the number of controller enclosures."
                return CheckedResult.NOTPASS, cliRet + cliRetItem, errMsg
            
            ctrlCount = len(util.formatList(cliRetItem))
            if ctrlCount != 1:
                if "zh" == lang:
                    errMsg += u"\n未查询到PCIe接口卡。" 
                else:
                    errMsg += u"The PCIe card being queried does not exist."
                return CheckedResult.NOTPASS, cliRet, errMsg
        else:
            for pciePort in pciePortList:
                pciePortID = pciePort.get("ID")
                healthStatus = pciePort.get("Health Status")
                if healthStatus != "Normal":
                    flag = CheckedResult.NOTPASS
                    tuple2Breplaced = (pciePortID, healthStatus) 
                    if "zh" == lang:
                        errMsg += u"\nPCIe端口[%s]健康状态异常（%s）。" % tuple2Breplaced
                    else:
                        errMsg += "\nThe health status of PCIe port[%s] is abnormal(%s)." % tuple2Breplaced
        
        return (flag, cliRet, errMsg)
                                   
    except Exception:
        log.error("Sequence[pciePortStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
