# -*- coding: UTF-8 -*-
import traceback
from common import util
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet, checkCliInfoValid
from common.contextUtil import getLang, getLogger,getSshObj
def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check SAS port status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        cliRet = ""
        errMsg = ""
        #Optimize check rate
        cliRet = getCliRet(dataDict, "show port general physical_type=SAS")
        
        if not util.checkCliInfoValid(cliRet, False):
            flag = CheckedResult.NOTPASS
            if lang == "zh":
                errMsg = u"\n无效CLI信息。"
            else:
                errMsg = "\nInvalid Cli information."
            return CheckedResult.NOTPASS, cliRet, errMsg
        
        linkupNumA = 0
        linkupNumB = 0
        sasPortList = util.formatList(cliRet)
        for sasPort in sasPortList:
            sasPortID = sasPort.get("ID")
            healthStatus = sasPort.get("Health Status")
            runningStatus = sasPort.get("Running Status")
            
            if healthStatus == "Normal":
                if runningStatus == "Link Down" or runningStatus == "Running":
                    continue
                elif runningStatus == "Link Up":
                    if ".A" in sasPortID:
                        linkupNumA += 1
                    else:
                        linkupNumB += 1
                else:
                    flag = CheckedResult.NOTPASS
                    tuple2Breplaced = (sasPortID, runningStatus)
                    if "zh" == lang:
                        errMsg += u"\nSAS端口[%s]运行状态异常（%s）。" % tuple2Breplaced
                    else:
                        errMsg += "\nThe running status of SAS port[%s] is abnormal(%s)." % tuple2Breplaced
            else:
                flag = CheckedResult.NOTPASS
                tuple2Breplaced = (sasPortID, healthStatus)
                if "zh" == lang:
                    errMsg += u"\nSAS端口[%s]健康状态异常（%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe health status of SAS port[%s] is abnormal(%s)." % tuple2Breplaced
            
        if linkupNumA != linkupNumB:
            flag = CheckedResult.NOTPASS
            if "zh" == lang:
                errMsg += u"\nSAS线缆连接不对称，A和B端口link up数量要相等。"
            else:
                errMsg += "\nThe link up of SAS port is not symmetrical, the link up number of port A and port B must be equaled."
        
        return (flag, cliRet, errMsg)
                                   
    except Exception:
        log.error("Sequence[sasPort] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
