# -*- coding: UTF-8 -*-
import traceback
import re
from common.constant import CheckedResult
from common.contextUtil import getLang, getLogger, getSshObj, getDevObj, getDestVer
from common.utils import getHorizontalCliRet
from common import modelManager
from common import cmdManager
from frame.common import common

def execute(context):
    '''
    @summary: 阵列前4保险箱盘漫游检查
    '''
    logger = getLogger(context)
    allRet = ''
    ssh = getSshObj(context)
    lang = getLang(context)
    try:
        flag = CheckedResult.PASS
        devObj = getDevObj(context)
        errMsg = ""
        cliRet = ""
        flagSwitch = False #每个保险盘检查结果标记
        tempList = []#前4个保险盘检查结果合集

        #先检查设备型号是否为S5500T，目标版本是否在如下列表中:
        devType = str(devObj.getDeviceType())#获取当前设备型号
        targetVersion = str(getDestVer(context))#获取评估目标版本

        if devType != 'S5500T':
            flag = CheckedResult.NOSUPPORT
            return (flag, allRet, errMsg)
        if targetVersion not in ['V200R002C30SPC200']:
            flag = CheckedResult.NOSUPPORT
            return (flag, allRet, errMsg)

        #步骤1：切换模式到diagnose下
        isSucc, errMsg = modelManager.changeCli2DiagnoseWithErrMsg(context)
        if not isSucc:
            logger.info("Sequence[top4DiskRoaming] failed login the Debug mode, out!")
            flag = CheckedResult.NOTPASS
            return (flag, allRet, errMsg)

        #步骤2：执行ld show disk查看前4盘逻辑LD与SlotId是否能对应上,即0-0,1-1,2-2,3-3；如果前4盘有不在位的场景，会产生告警，本检查项无需判断。
        cliRet = cmdManager.execCmd(context, 'ld show disk')
        allRet += cliRet + '\n'
        if cliRet.find("LD") == -1 or cliRet.find("SlotId") == -1:
            flag = CheckedResult.NOTPASS
            errMsg = common.getMsg(lang, 'get.result.abnormal') #"\n查询结果异常"
            return (flag, allRet, errMsg)

        dictList = getHorizontalCliRet(cliRet)#将Cli回显解析为字典列表

        for i in range(0, 4):
            if dictList[i].get('LD') in ['0', '1', '2', '3']:
                if dictList[i].get('LD') == dictList[i].get('SlotId'):
                    flagSwitch = True
                    tempList.append(flagSwitch)

                else:
                    flagSwitch = False
                    tempList.append(flagSwitch)
                    errMsg += common.getMsg(lang, 'has.disk.romaing',(dictList[i].get('LD'),dictList[i].get('SlotId')))#“\n保险盘存在漫游”

            if False in tempList:
                flag = CheckedResult.NOTPASS
        return (flag, allRet, errMsg)

    except Exception:
        logger.error("Sequence[top4DiskRoaming] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        errMsg = common.getMsg(lang, 'query.result.abnormal') #"\n获取信息失败"
        return (flag, allRet, errMsg)
    finally:
        try:
            modelManager.changeAnyModel2Cli(ssh)
        except:
            logger.error("Sequence[top4DiskRoaming] catch except.")