# -*- coding: UTF-8 -*-
import traceback
from common.util import checkCliInfoValid, formatStr
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check lun_copy general status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    flag = CheckedResult.PASS
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        cliRet = getCliRet(dataDict, "show lun_copy general")
        
        # 中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not checkCliInfoValid(cliRet, False):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = CheckedResult.PASS
            return (flag, cliRet, errMsg)
        
        formatedDictList = formatStr(cliRet)
        # LUN拷贝健康状况检查结果不通过时描述不准确  modified 20131109 begin
        for i in range(len(formatedDictList)):
            lunCopyID = unicode(formatedDictList[i].get("ID"))
            # Lun_Copy中运行状态为completed modified 20131128 begin
            healthStatus = unicode(formatedDictList[i].get("Health Status"))
            if "normal" != healthStatus.lower():
                tuple2Breplaced = (lunCopyID, healthStatus)
                log.info("Sequence[LUNCopyHealthStatus] inspect Lun_copy general, lunCopyID:%s, healthStatus:%s"  % tuple2Breplaced)
                flag = CheckedResult.NOTPASS
                if "zh" == lang:
                    errMsg += u"\nLUN拷贝[%s]状态异常（%s）。" % tuple2Breplaced
                else:
                    errMsg += "\nThe status of LUN copy[%s] is abnormal(%s)." % tuple2Breplaced
            # Lun_Copy中运行状态为completed modified 20131128 end
        # 中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
        # LUN拷贝健康状况检查结果不通过时描述不准确  modified 20131109 end
    except Exception:
        log.error("Sequence[LUNCopyHealthStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
