# -*- coding: UTF-8 -*-
import traceback
import re
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check remote device link status
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict,"show remote_device link")
        
        listRet = cliRet.splitlines()
        i = 0
        for field in listRet:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = CheckedResult.NOTPASS
                log.info("Sequence[replicationLinkStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            # add 20140220 begin
            if re.search("license", field, re.IGNORECASE):
                continue
            # add 20140220 end
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = CheckedResult.NOTPASS
                log.info("There is an error in Sequence[replicationLinkStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            # 巡检优化 modified 2013-12-10 begin
            i = i + 1
            if i > 4:
                lstField = field.split()
                if (len(lstField) < 1):
                    continue
                if -1 != lstField[0].find(":/>"):
                    break
                if "FC" == lstField[0] or "ISCSI" == lstField[0] or -1 != field.find("------") or "ID" == lstField[0]:
                    continue
                
                if (len(lstField) >= 8) and ("Normal" != lstField[1]):
                    log.info("Sequence[replicationLinkStatus] inspect remote device link status:" + lstField[1] + " ID: " + lstField[0])
                    flag = CheckedResult.NOTPASS
                    if "zh" == lang:
                        errMsg += u"\n远端设备链路[%s]健康状态检测异常" % lstField[0]
                    else:
                        errMsg += "\nThe health status of remote device link[%s] is abnormal" % lstField[0]
                    
        return (flag, cliRet, errMsg)
        # 巡检优化 modified 2013-12-10 end
        
    except Exception:
        log.error("Sequence[replicationLinkStatus] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
