# -*- coding: UTF-8 -*-
from common.constant import CheckedResult
from common.contextUtil import getLang, getLogger,getSshObj
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil

def execute(context):
    '''
        Disk enclosure number check
        Check whether the number of DAE0xx enclosures exceeds 20. 
        Do the same to DAE1xx enclosures, and so forth. 
    '''
    flag = CheckedResult.PASS
    lang = getLang(context)
    logger = getLogger(context)
        
    cliRet = ""
    errMsg = ""
    MAX_ENCLOSURE_NUM = 20
    DEV_VER_BLACK_LIST = ["V200R002C00SPC100",
                          "V200R002C00SPC200",
                          "V200R002C00SPC300",
                          "V200R002C00SPC400",
                          "V100R001C00SPC100",
                          "V100R001C00SPC200",
                          "V100R001C00SPC300",]
    try:
        cli = getSshObj(context)
        devVersion = contextUtil.getCurVersion(context)
        logger.info("[check_cli_software_enclosure_number]device version is %s" %devVersion)
        if devVersion not in DEV_VER_BLACK_LIST:
            return (CheckedResult.NOSUPPORT, cliRet, errMsg) 
        
        
        cmd = "show enclosure"
        cliResult = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = cliResult[1]
        if not cliResult[0]:
            return (CheckedResult.NOTPASS, cliRet, cliResult[2])
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(lang, "cannot.get.enclosure.info")
            logger.logNoPass("[check_cli_software_enclosure_number]Cannot get information about enclusure")
            return (CheckedResult.NOTPASS, cliRet, errMsg)
        
        encIdDict = {}
        abnormalLoops = set()
        for line in cliRetLinesList:
            encId = line["ID"]
            
            #if not disk enclosure, continue
            if "DAE" not in encId:
                continue
            
            encPrefix = encId[:4]
            hisEncCount = encIdDict.get(encPrefix,0)
            encIdDict[encPrefix] = hisEncCount + 1
            if encIdDict[encPrefix] > MAX_ENCLOSURE_NUM:
                flag = CheckedResult.NOTPASS
                abnormalLoops.add(encPrefix)
            
        abnormalLoops = sorted(abnormalLoops)
        for enc in abnormalLoops:
            errMsg += common.getMsg(lang,"enclosure.number.too.much",(enc, encIdDict[enc]))
        
        return (flag, cliRet, errMsg)
    except Exception, exception:     
        logger.logException(exception)
        return (CheckedResult.NOTPASS, cliRet, common.getMsg(lang, "query.result.abnormal"))

