# -*- coding: UTF-8 -*-
import traceback
import re 
from common.constant import CheckedResult
from common.cmdRetManager import getCliRet
from common.contextUtil import getLang, getLogger
from common.util import checkCliInfoValid, formatStr

def execute(dataDict):
    '''
    @summary: the entrance of main method, this check item is used to check Hot Spare Capacity
    @param dataDict: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    try:
        flag = CheckedResult.PASS
        lang = getLang(dataDict)
        log = getLogger(dataDict)
        errMsg = ""
        cliRet = getCliRet(dataDict, "show disk_domain general")
        
        # 中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not checkCliInfoValid(cliRet, False):
                flag = CheckedResult.NOTPASS
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = CheckedResult.PASS
            return (flag, cliRet, errMsg)
        
        formatedDictList = formatStr(cliRet)
        for i in range(len(formatedDictList)):
            diskDomainID = unicode(formatedDictList[i].get("ID"))
            usedHotSpareCap = unicode(formatedDictList[i].get("Used Hot Spare Capacity"))
            # 巡检优化 modified 2013-12-10 begin
            if usedHotSpareCap != "0.000B":
                flagItem, flagTemp, cliRetItem, errMsgItem = checkDiskStatus(dataDict, diskDomainID)
                if not flagTemp:
                    flag = CheckedResult.NOTPASS
                    return (flag, cliRet+cliRetItem, errMsgItem)
                
                if not flagItem:
                    log.info("Sequence[HotSpareCapacity] inspect Used Hot Spare Capacity:" + usedHotSpareCap)
                    cliRet += "\n" + cliRetItem 
                    flag = CheckedResult.NOTPASS
                    if "zh" == lang:
                        errMsg += u"\nDomain[%s]的Used Hot Spare Capacity不为0。" % diskDomainID
                    else:
                        errMsg += "\nThe Used Hot Spare Capacity in domain[%s] is not 0." % diskDomainID
        # 中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
        # 巡检优化 modified 2013-12-10 end
    except Exception:
        log.error("Sequence[HotSpareCapacity] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
    
# **************************************************************************** #
# 函数名称: checkDiskStatus
# 功能说明: 检查disk_domain下的硬盘状态是否正常
# 输入参数: cli，diskdomain
# 输出参数: 无
# 返 回 值: flag, flagErr, cliRet, errMsg
# **************************************************************************** # 
def checkDiskStatus(dataDict, diskDomainID):   
    flag = True
    flagErr = True
    cliRet = ""
    lang = getLang(dataDict)
    errMsg = ""
    filterCmd = "|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online"        
    cmd = "show disk in_domain disk_domain_id=" + unicode(diskDomainID) + filterCmd
    cliRet = getCliRet(dataDict, cmd)
    lines = cliRet.splitlines()
    i = 0
    for field in lines:
        if field.startswith("-bash") or field.startswith("upgrade"):
            flagErr = False
            if "zh" == lang:
                errMsg = u"\n系统没有运行在admin模式。"
            else:
                errMsg = "\nSystem is not in admin Mode."
            return (flag, flagErr, cliRet, errMsg)
 
        if re.search("Error:", field, re.IGNORECASE):
            flagErr = False
            if "zh" == lang:
                errMsg = u"\n获取信息出错"
            else:
                errMsg = "\nThere is an error in getting information."
            return (flag, flagErr, cliRet, errMsg)
        
        i = i+1    
        if i > 3:
            flag = False
            return (flag, flagErr, cliRet, errMsg)
        
    return (flag, flagErr, cliRet, errMsg)