# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.common.config import HOT_PATCH_VERSION_DICT

def execute(context):
    '''
    @summary: 特殊路径下是否安装热补丁
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    needInstallFlag = True
    cliRet = ""
    errMsg = ""
    try:
        #获取当前版本号
        curVersion = contextUtil.getCurVersion(context)
        logger.logInfo('curVersion:%s'%curVersion)
        if curVersion not in HOT_PATCH_VERSION_DICT.keys():
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        #获取补丁版本号
        getHotPatchVersionRet = common.getHotPatchVersion(context)
        if not getHotPatchVersionRet[0]:
            return common.getUpgEvaluationRs(getHotPatchVersionRet[0], getHotPatchVersionRet[2], getHotPatchVersionRet[3])
        hotPatchVersion = getHotPatchVersionRet[1]
        logger.logInfo('hotPatchVersion:%s'%hotPatchVersion)
        dueHotPatchVersionList = HOT_PATCH_VERSION_DICT.get(curVersion)
        #判断标准以最后安装补丁为准
        if dueHotPatchVersionList[-1].endswith('+'):
            dueHotPatchVersion = dueHotPatchVersionList[-1][:-1]
            if hotPatchVersion >= dueHotPatchVersion:
                needInstallFlag = False
        else:
            if hotPatchVersion == dueHotPatchVersionList[-1]:
                needInstallFlag = False
        
        logger.logInfo('needInstallFlag:%s'%str(needInstallFlag))
        cliRet = getHotPatchVersionRet[2]
        if not needInstallFlag:
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        else:
            resourceHotPatchVersionStr = common.getMsg(lang, 'comma.res').join(dueHotPatchVersionList)
            resourceHotPatchVersionStr = resourceHotPatchVersionStr.replace('+', common.getMsg(lang, 'install.patch.hotpatch'))
            errMsg = common.getMsg(lang, "install.onlyone.hotpatch", resourceHotPatchVersionStr)
            if len(dueHotPatchVersionList) > 1:
                errMsg = common.getMsg(lang, "install.many.hotpatch", resourceHotPatchVersionStr)
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
            
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    