# -*- coding: UTF-8 -*-
import traceback
import re

from common import util
from common.constant import CheckedResult
from common.contextUtil import getLang, getLogger
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil

def execute(context):
    '''
    @summary: 系统预留内存空间大小检查
    '''
    flag = CheckedResult.PASS
    allCliRet = ''
    errMsg = ''
    lang = getLang(context)
    logger = getLogger(context)
    try:
        #步骤1：获取所有控制器IP和ID
        ctrlIpAndIdTupList = contextUtil.getCtrlIpAndIdMap(context)
        if not ctrlIpAndIdTupList:
            logger.error("Sequence[reservedMemory] failed to get the controller Id and IP TupList.")
            flag = CheckedResult.WARN
            return (flag, allCliRet, common.getMsg(lang, "query.result.abnormal"))

        #步骤2：对每个控制器都执行检查
        for contrlInfo in ctrlIpAndIdTupList:
            ctrlId = contrlInfo[0]
            ctrlIpv4 = contrlInfo[1]
            ctrlIpv6 = contrlInfo[2]
            #检查可能结果：通过，不通过，警告
            checkRet = checkEachCtrlResMem(context, (ctrlIpv4,ctrlIpv6), ctrlId)
            if checkRet[1]:
                checkRetTmp = "[Controller %s's details]:" % ctrlId
                allCliRet += checkRetTmp + '\n' + checkRet[1].strip() + '\n\n'
            if checkRet[0] == CheckedResult.PASS:#通过
                midMsg = common.getMsg(lang, 'controller.check.pass')
                errMsg += common.getMsg(lang, 'title.controller', ctrlId) + midMsg + os.linesep
                continue
            errMsg += common.getMsg(lang, 'title.controller', ctrlId) + checkRet[2] + '\n'
            if checkRet[0] == CheckedResult.NOTPASS:#不通过
                flag = CheckedResult.NOTPASS
                continue
            if flag != CheckedResult.NOTPASS:   #其他检查结果如警告，优先报不通过
                flag = CheckedResult.WARN
        return (flag, allCliRet.strip(), errMsg)
    except Exception: 
        logger.error("Sequence[reservedMemory] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        return (flag, allCliRet, common.getMsg(lang, "query.result.abnormal"))

def checkEachCtrlResMem(context, ctrlIpS, ctrlId):
    '''
    @summary: 单个控制器预留内存检查
    '''
    lang = contextUtil.getLang(context)
    logger = getLogger(context)
    
    flag = CheckedResult.PASS
    cliRet = ""
    errMsg = ""
    logger.info('Sequence[reservedMemory] start checking controller[%s]' % ctrlId)

    curCtrlIp = contextUtil.getCurCtrlIp(context)
    if curCtrlIp == ctrlIpS[0] or curCtrlIp == ctrlIpS[1]:#当前控制器直接获取
        cli = contextUtil.getSSH(context)
    else:#新建cli连接
        cli = contextUtil.createCliConnection(context, ctrlIpS[0])
        if cli is None:
            cli = contextUtil.createCliConnection(context, ctrlIpS[1])
    if cli == None:
        logger.info('Sequence[reservedMemory] create controller [%s] cli connection failed.' %ctrlId)
        errMsg = common.getMsg(lang, 'cannot.create.controller.cli')
        return (CheckedResult.WARN, cliRet, errMsg)
    try:
        #查看预留内存信息
        cmd = 'sys showmem'
        tempFlag, cliRet, errMsg = cliUtil.executeCmdInDebugMode(context, cmd, True, cli)
        if tempFlag != True:
            flag = CheckedResult.NOTPASS
            logger.info('Sequence[reservedMemory] controller [%s] execute command failed.' % ctrlId)
            return (flag, cliRet, errMsg)     
        
        # start*********************兼容SPC100的回文   ************
        if 'System reserved struct info' in cliRet:
            memTypeRetDict = getListDictFromStr(cliRet)
        # end*********************兼容SPC100的回文   ************
        else:
            memTypeRet = getRetByKeyWord(cliRet,'RsvMemType')
            memTypeRetDict = util.formatStr(memTypeRet)
        
        if not memTypeRetDict:
            flag = CheckedResult.NOTPASS
            errMsg = common.getMsg(lang, 'get.result.abnormal') #"\n查询结果异常"
            return (flag, cliRet, errMsg)
            
        for item in memTypeRetDict:
            revMemName = item.get("name")
            if 'RsvMemType: RpcDbgInfo' == revMemName or revMemName.endswith("_Const"):
                continue
            if int(item.get("used"))>= int(item.get("struct num")):
                flag = CheckedResult.NOTPASS
                errMsg = common.getMsg(lang, 'check.reserver.memory.notpass')#"\n预留内存不足。"
                return (flag, cliRet, errMsg)
        return (flag, cliRet, errMsg)
    except Exception:
        logger.error("Sequence[reservedMemory] controller[%s] catch except of trace back:" % ctrlId + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        errMsg = common.getMsg(lang, 'query.result.abnormal') #"\n获取信息失败"
        return (flag, cliRet, errMsg)
    finally:
        if curCtrlIp != ctrlIpS[0] and curCtrlIp != ctrlIpS[1]:
            cliUtil.closeCliConnection(cli)
        
def getRetByKeyWord(cliRet, keyword, splitPatten = ''):
    '''
    @summary: 截取回文中关键词所在行后面的内容，遇到回文末尾或缩进小于关键词的缩进或缩进一样且包含同样分隔符的行就返回
    @param cliRet: 回文
    @param keyword: 关键词，使用match搜索，因此需要从行开始的第一个字符算起
    @param splitPatten: 分隔符组成的字符串,多种分隔符之间使用'|'分割（避免关键词后面行缩进和关键词一样导致提前截断）
    @return: string
    '''
    if keyword not in cliRet:
        return ''
    restr = ''
    switchFlag = False
    spaceNum = 0
    for line in cliRet.splitlines():
        if re.match(keyword, line):
            switchFlag = True
            spaceNum = len(line.rstrip()) - len(line.strip())
            continue
        if switchFlag:
            if line.strip() == '':
                continue
            curspaceNum = len(line.rstrip()) - len(line.strip())
            if curspaceNum <= spaceNum or '>' in line:         #遇到缩进比关键词所在行缩进小或相等的行或回文末尾
                break
            if curspaceNum == spaceNum and (not splitPatten or re.search(splitPatten,line)):   #遇到同样缩进且分隔符一致
                break
            else:
                restr += line + '\n'
    return restr

def getListDictFromStr(cliRet):
    '''
    @summary: 回文的每一行组成 字典，所有的行组成一个List
    @param cliRet: 回文
    @return: List
    '''
    reList = []    
    for line in cliRet.splitlines():
        if not line.startswith('RsvMemType->'):
            continue
        itemDict = {}
        itemList = line.split('|')
        for itemStr in itemList:
            if ':' not  in itemStr:
                continue
            if 'name:' in itemStr:
                itemDict['name'] = itemStr.replace('name:','').strip()
            else:
                dictKey = itemStr.split(':')[0].strip()
                itemDict[dictKey] = itemStr.split(':')[-1].strip()
        if itemDict:
            reList.append(itemDict)
    return reList
    