# -*- coding: UTF-8 -*-
import traceback
import re
from common.constant import CheckedResult
from common.contextUtil import getLang, getLogger, getSshObj
from common import modelManager
from common import cmdManager

totalLogNumStr = "Total log num:"
remainFreeLogNumStr = "Remain free log num:"

def execute(context):
    '''
    @summary: 系统配置数据检查
    '''
    logger = getLogger(context)
    try:
        flag = CheckedResult.PASS
        lang = getLang(context)
        ssh = getSshObj(context)
        errMsg = ""
        cliRet = ""
        allRet = ''

        #步骤1：切换模式到diagnose下
        isSucc, errMsg = modelManager.changeCli2DiagnoseWithErrMsg(context)
        if not isSucc:
            logger.info("Sequence[sysConfigLog] failed login the Debug mode, out!")
            flag = CheckedResult.NOTPASS
            return (flag, allRet, errMsg)

        #步骤2：执行sys showcls查看控制器节点，若小于等于3则继续检查，否则报警告
        cliRet = cmdManager.execCmd(context, 'sys showcls')
        allRet += cliRet + '\n'
        if 'local node id' not in cliRet:
            flag = CheckedResult.NOTPASS
            errMsg = common.getMsg(lang, 'get.result.abnormal') #"\n查询结果异常"
            return (flag, allRet, errMsg)

        for line in cliRet.splitlines():
            if 'local node id' in line:
                curNodeID = line.split(':')[-1].strip()
                if curNodeID not in ['0', '1', '2', '3']:
                    flag = CheckedResult.WARN
                    errMsg = common.getMsg(lang, 'check.sys.configlog.warn')
                    return (flag, allRet, errMsg)

                    #步骤3：执行sys showcfglog查看是否存在系统配置LOG
        cliRet = cmdManager.execCmd(context, 'sys showcfglog')
        allRet += cliRet + '\n'
        #数据零时保存对象        
        totalLogNumVal = ""
        remainFreeLogNumVal = ""
        for line in cliRet.splitlines():
            if re.search(totalLogNumStr, line, re.IGNORECASE):
                totalLogNumVal = line.split(":")[-1].strip()
                continue
            if re.search(remainFreeLogNumStr, line, re.IGNORECASE):
                remainFreeLogNumVal = line.split(":")[-1].strip()
                continue
        #totalLogNumVal or remainFreeLogNumVal 不能为空且必须相等
        if not totalLogNumVal or not remainFreeLogNumVal:
            flag = CheckedResult.NOTPASS
            errMsg = common.getMsg(lang, 'get.result.abnormal') #"\n查询结果异常"
        elif totalLogNumVal != remainFreeLogNumVal:
            flag = CheckedResult.NOTPASS
            errMsg = common.getMsg(lang, 'check.sys.configlog.notpass')#"\nTotal log num与Remain free log num的值不相等，存在系统配置LOG。"               
        return (flag, allRet, errMsg)
    except Exception:
        logger.error("Sequence[sysConfigLog] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        errMsg = common.getMsg(lang, 'query.result.abnormal') #"\n获取信息失败"
        return (flag, allRet, errMsg)
    finally:
        try:
            modelManager.changeAnyModel2Cli(ssh)
        except:
            logger.error("Sequence[sysConfigLog] failed change mode to cli mode!")
