# -*- coding: UTF-8 -*-
import traceback
from common.constant import CheckedResult
from common.contextUtil import getLang, getLogger
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil

def execute(context):
    '''
    @summary: 系统流程检测
    '''      
    flag = CheckedResult.PASS
    allCliRet = ''
    errMsg = ''
    lang = getLang(context)
    logger = getLogger(context)
    try:
        #步骤1：获取所有控制器IP和ID
        ctrlIpAndIdTupList = contextUtil.getCtrlIpAndIdMap(context)
        if not ctrlIpAndIdTupList:
            logger.error("Sequence[sysProcesses] failed to get the controller Id and IP TupList.")
            flag = CheckedResult.WARN
            return (flag, allCliRet, common.getMsg(lang, "query.result.abnormal"))
        
        #步骤2：对每个控制器都执行检查
        for contrlInfo in ctrlIpAndIdTupList:
            ctrlId = contrlInfo[0]
            ctrlIpv4 = contrlInfo[1]
            ctrlIpv6 = contrlInfo[2]
            #检查可能结果：通过，不通过，警告
            checkRet = checkEachCtrlSysPre(context, (ctrlIpv4,ctrlIpv6), ctrlId)
            if checkRet[1]:
                checkRetTmp = "[Controller %s's details]:" % ctrlId
                allCliRet += checkRetTmp + '\n' + checkRet[1].strip() + '\n\n'
            if checkRet[0] == CheckedResult.PASS:#通过
                midMsg = common.getMsg(lang, 'controller.check.pass')
                errMsg += common.getMsg(lang, 'title.controller', ctrlId) + midMsg + os.linesep
                continue
            errMsg += common.getMsg(lang, 'title.controller', ctrlId) + checkRet[2] + '\n'
            if checkRet[0] == CheckedResult.NOTPASS:#不通过
                flag = CheckedResult.NOTPASS
                continue
            if flag != CheckedResult.NOTPASS:   #其他检查结果如警告，优先报不通过
                flag = CheckedResult.WARN 
        return (flag, allCliRet.strip(), errMsg)
    except Exception: 
        logger.error("Sequence[sysProcesses] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        return (flag, allCliRet, common.getMsg(lang, "query.result.abnormal"))

def checkEachCtrlSysPre(context, ctrlIpS, ctrlId):
    '''
    @summary: 单个控制器系统流程检查
    '''
    lang = contextUtil.getLang(context)
    logger = getLogger(context)
    
    flag = CheckedResult.PASS
    cliRet = ""
    allRet = ""
    errMsg = ""
    logger.info('Sequence[sysProcesses] start checking controller[%s]' % ctrlId)
    
    curCtrlIp = contextUtil.getCurCtrlIp(context)
    if curCtrlIp == ctrlIpS[0] or curCtrlIp == ctrlIpS[1]:#当前控制器直接获取
        cli = contextUtil.getSSH(context)
    else:#新建cli连接
        cli = contextUtil.createCliConnection(context, ctrlIpS[0])
        if cli is None:
            cli = contextUtil.createCliConnection(context, ctrlIpS[1])
    if cli == None:
        logger.info('Sequence[sysProcesses] create controller [%s] cli connection failed.' % ctrlId)
        errMsg = common.getMsg(lang, 'cannot.create.controller.cli')
        return (CheckedResult.WARN, allRet, errMsg)
    
    try:
        #查看预留内存信息
        cmd = 'sys showcmdlist'
        queryTimes = 0
        while True:
            queryTimes += 1
            tempFlag, cliRet, errMsg = cliUtil.executeCmdInDebugMode(context, cmd, True, cli)
            if cliRet:
                allRet += cliRet + '\n'
            if tempFlag != True:
                flag = CheckedResult.NOTPASS
                logger.info('Sequence[sysProcesses] controller [%s] execute command failed.' % ctrlId)
                return (flag, allRet, errMsg)
            if 'index:' not in cliRet:
                flag = CheckedResult.PASS
                break
            else: 
                if queryTimes >= 3: 
                    flag = CheckedResult.NOTPASS
                    errMsg = common.getMsg(lang, 'check.sys.processes.notpass')#"\n存在正在执行或等待的系统流程。"
                    break
                else: 
                    time.sleep(10)
        return (flag, allRet, errMsg)
    except Exception:
        logger.error("Sequence[sysProcesses] controller[%s] catch except of trace back:" % ctrlId + unicode(traceback.format_exc()))
        flag = CheckedResult.NOTPASS
        errMsg = common.getMsg(lang, 'query.result.abnormal') #"\n获取信息失败"
        return (flag, allRet, errMsg)
    finally:
        if curCtrlIp != ctrlIpS[0] and curCtrlIp != ctrlIpS[1]:
            cliUtil.closeCliConnection(cli)
