# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: 磁盘单链路检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRetValue = "Note: The following information is only for manual check, and it does not affect the final evaluation result.\n\n"
    try:
        
        tlv = contextUtil.getTlvObj(context)
        flag = True
        errMsg = ""
        checkItem = "CHECK_DISK_LINKSTATUS"
        logger.logExecCmd(checkItem)
        #根据检查项获取配置字典值
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        #获取cli回显，不管回显是啥都将其返回到原始信息
        cli = contextUtil.getSSH(context)
        cmd = "show alarm |filterRow column=ID predict=equal_to value=0xF00A000C"
        cliRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRetValue += cliRet[1]
        
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            itemVal = itemDict.get(result, None)
            if itemVal is None:
                errMsg += common.getMsg(lang, "check.result.abnormal", nodeId)
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"], nodeId)
        return common.getUpgEvaluationRs(flag, cliRetValue, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetValue, common.getMsg(lang, "query.result.abnormal"))
    