# -*- coding: UTF-8 -*-
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData

def execute(context):
    '''
    @summary: PCIe链路检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = "Note: The following information is only for manual check, and it does not affect the final evaluation result.\n\n"
    try:
        
        tlv = contextUtil.getTlvObj(context)
        flag = True
        errMsg = ""
        checkItem = "CHECK_HARDWARE_PCIE_LINKSTATUS"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        errMsgList = []#保存错误信息的列表
        for record in recs:
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            itemKey = itemDict.get(result, None)
            if itemKey is None:
                errMsgList.append(common.getMsg(lang, "query.result.abnormal"))
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemKey["status"]
            if status is True:
                continue
            flag = False
            errMsgList.append(common.getMsg(lang, itemKey["msg"], nodeId))
        errMsg = "".join(errMsgList)
        if flag == False:
            cliRet += "The PCIe links are faulty."
        else:
            cliRet += "The PCIe links are normal."
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    