# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData
import os
from frameone.util import baseUtil

def execute(context):
    '''
    @summary: 系统资源检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = "Note: The following information is only for manual check, and it does not affect the final evaluation result.\n\n"
    NORMAL_MEMORY = 270
    OFFLINE_CPUUSAGE = 85
    ONLINE_CPUUSAGE = 60
    context["checkState"] = common.PROCESS_STATE_CHECKING
    item = "tlv_software_sysResource"

    try:
        # 进度条刷新
        common.threadUp(context, item)

        flag = True
        errMsg = ""
        tlv = contextUtil.getTlvObj(context)
        upgmode = contextUtil.getUpgradeModel(context)
        checkItem = "CHECK_SOFTWARE_SYSRESOURCE"
        logger.logExecCmd(checkItem)
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]#根据检查项获取配置字典值
        recs = tlvUtil.getUpgradeRecords(tlv, checkItem)
        logger.logInfo("records=%s" % unicode(recs))
        
        #'S2600T', 'S5500T'内存阈值特殊处理
        devType = contextUtil.getDevType(context)
        if str(devType) in ['S2600T', 'S5500T']:
            NORMAL_MEMORY = 200
        checkDetail = ""
        for record in recs:
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["NODE_ID"])
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["RESULT"])
            itemKey = None
            rsList = result.split(",")
            if len(rsList) > 1:
                cpuUsage = int(rsList[0])
                memoryRemain = int(rsList[1])
                checkDetail += baseUtil.getMsg(lang, "SysResourceCheck.detail",
                                               (nodeId, str(cpuUsage) + '%', str(memoryRemain)))
                if upgmode == "OFFLINE":
                    if cpuUsage <= OFFLINE_CPUUSAGE and memoryRemain >= NORMAL_MEMORY:
                        itemKey = "True"
                    else:
                        itemKey = "False"
                elif upgmode == "ONLINE":
                    if cpuUsage <= ONLINE_CPUUSAGE and memoryRemain >= NORMAL_MEMORY:
                        itemKey = "True"
                    else:
                        itemKey = "False"
            else:
                itemKey = result
            itemVal = itemDict.get(itemKey, None)#根据模块返回值获取对应的字典值,如果失败返回None
            if itemVal is None:
                errMsg += common.getMsg(lang, "check.result.abnormal", nodeId)
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemVal.get("status")
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"], nodeId)
        if flag == False:
            cliRet += "The system resource usage is too high."
        else:
            cliRet += "The system resource usage is normal."
        cliRet += checkDetail
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))

    finally:
        try:
            common.finishProcess(context, item)
            logger.logInfo("the thread is finished")
        except:
            common.setProgress(context, common.PROGRESS_NUM_MAX, item)