# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData
from frame.tlv import tlvDataType

def execute(context):
    '''
    @summary: 导入升级包空间检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    errMsg = ""
    flag = True
    
    devVerList = ["V200R002C00SPC200","V200R002C00SPC400"]
    patchVersion = "V200R002C00SPH299"
    TYPICAL_PKG_SIZE = 351272960
    ERRCODE_PKG_NOT_ENOUGH = 1077949093
    
    try:
        #获取设备型号和版本
        curVersion = contextUtil.getCurVersion(context)
        if curVersion not in devVerList:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        if devVerList[0] == curVersion:
            #获取补丁版本号
            getHotPatchVersionRet = common.getHotPatchVersion(context)
            cliRet += getHotPatchVersionRet[2]
            if not getHotPatchVersionRet[0]:
                return common.getUpgEvaluationRs(getHotPatchVersionRet[0], cliRet, getHotPatchVersionRet[3])
            
            hotPatchVersion = getHotPatchVersionRet[1]
            logger.logInfo("HotpatchVersion:%s"%hotPatchVersion)
            #没有安装SPH299补丁提示安装
            if patchVersion != hotPatchVersion:
                flag = False
                errMsg += common.getMsg(lang, "install.onlyone.hotpatch", patchVersion)
                return common.getUpgEvaluationRs(flag, cliRet, errMsg)

        #下发查询导包的空间
        tlv = contextUtil.getTlvObj(context) 
        #下发查询剩余内存命令
        params=[({"index":0, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},1),({"index":2, "type":tlvDataType.DATA_TYPE_UNSIGN_INT},TYPICAL_PKG_SIZE)]
        logger.logInfo("Before sending space TLV command.")
        retRec = tlvUtil.execCmd(tlv, tlvData.CMD["OM_MSG_OP_GET_PACKAGE_UPLOADPATH"], params)
        logger.logInfo("After sending space TLV command.")
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    except Exception, exception:
        flag = False
        logger.logNoPass("exception args:" + str(exception.args))
        if ERRCODE_PKG_NOT_ENOUGH == exception.args[0]:
            return common.getUpgEvaluationRs(flag, cliRet, common.getMsg(lang, "package.space.notenough"))
        else:
            return common.getUpgEvaluationRs(flag, cliRet, common.getMsg(lang, "query.result.abnormal"))

