# -*- coding: UTF-8 -*-

import time
from common.constant import CheckedResult
from common.util import formatDict
from common.contextUtil import getPdtVer,getLang,getLogger,getLoginUserName,getDeveloperPwd,getDevIp,getExtraDataDict,getDestVer,getCurSysVer,getSshObj
from common.sysInfoManager import getCurSystemVersion
from common.cmdRetManager import getCliRet
from frame.cli import cliUtil
from frame.common import common
import sys
reload(sys)
sys.setdefaultencoding('utf8')

def execute(context):
    '''
    @summary: the entrance of main method, do preparing check before evaluation
    @param context: the dictionary of data which provided by tool framework
    @return: (pass status, CLI information, error message) as (boolean, string, string)
    '''
    flag = CheckedResult.PASS
    cliRet = ''
    errMsg = ''
    lang = getLang(context)
    logger = getLogger(context)
    item = "pre_check"
    try:
        #保存时间戳信息
        creatAndSaveTimeStamp(context)

        #保存规范化后的当前系统版本信息（或称产品版本信息）
        getExtraDataDict(context)['curSysVer'] = getPdtVer(context)

        flagLst = []
        errMsgLst = []
        #检查设备状态
        flag, errMsg = isDeviceNormal(context)
        if CheckedResult.NOTPASS == flag:
            logger.error('check if the device is normal!')
            return (flag, cliRet, errMsg)

        common.setProgress(context, common.PROGRESS_NUM_5, item)
        funFlag, funErrMsg = isAdminUser(context)
        flagLst.append(funFlag)
        if CheckedResult.NOTPASS == funFlag:
            errMsgLst += funErrMsg
            logger.error('check if it is admin user failed!')
        common.setProgress(context, common.PROGRESS_NUM_10, item)
        funFlag, funErrMsg = hasDeveloperPass(context)
        flagLst.append(funFlag)
        if CheckedResult.NOTPASS == funFlag:
            errMsgLst += funErrMsg
            logger.error('check if it has developer password failed!')
        common.setProgress(context, common.PROGRESS_NUM_20, item)
        funFlag, funErrMsg = isDeviceVerValid(context)
        flagLst.append(funFlag)
        if CheckedResult.NOTPASS == funFlag:
            errMsgLst += funErrMsg
            logger.error('check if device version is valid failed!')
        common.setProgress(context, common.PROGRESS_NUM_40, item)
        funFlag, funErrMsg = isVersionValid(context)
        flagLst.append(funFlag)
        if CheckedResult.NOTPASS == funFlag:
            errMsgLst += funErrMsg
            logger.error('check if destination version is valid failed!')
        common.setProgress(context, common.PROGRESS_NUM_60, item)
        setCtrlIpAndIdMap(context)
        common.setProgress(context, common.PROGRESS_NUM_80, item)

        if CheckedResult.NOTPASS in flagLst:
            flag = CheckedResult.NOTPASS

        for index in range(len(errMsgLst)):
            if lang == "zh":
                errMsg += u"【问题%s】:\n%s\n\n" %(index+1,errMsgLst[index])
            else:
                errMsg += "[Problem %s]:\n%s\n\n" %(index+1,errMsgLst[index])

        return flag,cliRet,errMsg

    finally:
        common.setProgress(context, common.PROGRESS_NUM_MAX, item)

def setCtrlIpAndIdMap(context):
    '''
    @summary: set controller IP and ID map
    @param context: the context object provided by tool framework
    @return: (pass or not, error message) as (integer, string)
    '''
    ssh = getSshObj(context)
    logger = getLogger(context)
    lang = getLang(context)
    ctrlsIpsRet = cliUtil.getCtrlIps(ssh, logger, lang)
    logger.info('get all ctrollers ip result:%s' % unicode(ctrlsIpsRet))
    if not ctrlsIpsRet[0]:#无法获取控制器ip
        logger.error('There is an error in getting controller information.')
    else:
        getExtraDataDict(context)['ctrlIpAndIdMap'] = ctrlsIpsRet[1]
    return


def isDeviceNormal(context):
    '''
    @summary: judge whether the device status is normal
    @param context: the context object provided by tool framework
    @return: the status of device which is normal or abnormal, as boolean
    '''
    funFlag = CheckedResult.PASS
    funErrMsg = ''
    
    log = getLogger(context)
    cliRet = getCliRet(context, 'show system general')
    sysStatusDict = formatDict(cliRet)
    sysRunStatus = sysStatusDict.get('Running Status')
    sysHealStatus = sysStatusDict.get('Health Status')
    if 'Normal' != sysRunStatus or 'Normal' != sysHealStatus:
        funFlag = CheckedResult.NOTPASS
        log.error('[pre_check]System status is not normal.')
        lang = getLang(context)
        if lang == 'zh':
            funErrMsg = u'系统状态异常。'
        else:
            funErrMsg = 'The system is abnormal.'
    
    return (funFlag, funErrMsg)


def isDeviceVerValid(context):
    '''
    @Function name      : isDeviceVerValid
    @Function describe  : 判断上下文中的版本信息是否有效
    @Input              : context
    @Return             : funFlag,funRet,funErrMsg
    '''
    funFlag = CheckedResult.NOTPASS
    funErrMsg = []
    
    #从上下文中获取当前版本并转化为标准格式
    curVersion = getCurSysVer(context)
    #从设备上获取当前版本
    deviceVersion = ''
    lang = getLang(context)
    
    retVersion = getCurSystemVersion(context)
    if not retVersion[0]:
        if lang == "zh":
            funErrMsg.append(u"获取设备版本信息失败。")
        else:
            funErrMsg.append("Failed to get the device version.")
        return funFlag, funErrMsg
    
    deviceVersion = retVersion[1]
    if curVersion == deviceVersion:
        funFlag = CheckedResult.PASS
        getExtraDataDict(context)['curSysVer'] = curVersion 
        getExtraDataDict(context)['cliRet4UpgradePkgInfo'] = retVersion[2]
    else:
        if lang == "zh":
            funErrMsg.append(u"设备当前版本为%s,工具保存的设备版本为%s,请关闭当前子工具并在工具设备管理界面重新添加或更新设备。" %(deviceVersion,curVersion))
        else:
            funErrMsg.append("The current version of the device is %s but that in the tool is %s. Close the current subtool and add the device again or refresh the device in the device management interface of the tool." %(deviceVersion,curVersion))
    return funFlag, funErrMsg

def isAdminUser(context):
    '''
    @Function name      : isAdminUser
    @Function describe  : 判断是否是admin用户登录
    @Input              : context
    @Return             : funFlag,funRet,funErrMsg
    '''
    funFlag = CheckedResult.NOTPASS
    funErrMsg = []
    
    loginUser = getLoginUserName(context)
    if  'admin' == loginUser:
        funFlag = CheckedResult.PASS
    else:
        lang = getLang(context)
        if lang == "zh":
            funErrMsg.append(u"当前登录用户不为admin，请使用admin用户重新登录。")
        else:
            funErrMsg.append("The current user is not admin. Log in as user admin.")
            
    return funFlag, funErrMsg
    
def creatAndSaveTimeStamp(context):
    '''
    @Function name      : creatAndSaveTimeStamp
    @Function describe  : 创建本执行流程的ip+时间戳信息
    @Input              : context
    @Return             : 
    '''
    curTime = time.strftime('%Y%m%d%H%M%S',time.localtime(time.time()))
    deviceIp = getDevIp(context)
    
    timeStamp = deviceIp + "_" + curTime
    getExtraDataDict(context)['timeStamp'] = timeStamp 
    return

def hasDeveloperPass(context):
    '''
    @Function name      : isAdminUser
    @Function describe  : 判断是否有developer密码
    @Input              : context
    @Return             : funFlag,funErrMsg,devType
    '''
    funFlag = CheckedResult.NOTPASS
    funErrMsg = []
    
    developerPass = getDeveloperPwd(context)
    if developerPass:
        funFlag = CheckedResult.PASS
    else:
        lang = getLang(context)
        if lang == "zh":
            funErrMsg.append(u"添加设备时，未输入调试密码，请输入正确的调试密码后重试。")
        else:
            funErrMsg.append("Debug password was not entered when adding the device. Please enter the correct debug password and try again.")
            
    return funFlag, funErrMsg

def isVersionValid(context):
    '''
    @Function name      : isVersionValid
    @Function describe  : 判断版本是否有效
    @Input              : context
    @Return             : funFlag,funErrMsg,devType
    '''
    
    funFlag = CheckedResult.PASS
    funErrMsg = []
    #源版本
    curVer=getCurSysVer(context)
    #目标版本
    destVer=getDestVer(context)
    #语言环境
    lang = getLang(context)
        
    #向框架提需求，目标版本不能为空
    #有效性检查（1）：输入的当前版本号不能为空  
    if not destVer:
        funFlag = CheckedResult.NOTPASS
        if lang == "zh":
            funErrMsg.append(u"升级目标版本号为空，不能执行检查，请重新输入。")
        else:
            funErrMsg.append("The target version is left empty and the upgrade evaluation cannot be performed. Enter a target version. ")
           
    #有效性检查（2）：当前版本号与目标版本号不允许相同
    if curVer == destVer:
        funFlag = CheckedResult.NOTPASS
        if lang == "zh":
            funErrMsg.append(u"当前版本与目标版本相同，不能执行评估，请重新输入。")
        else:
            funErrMsg.append("The target version is the same as the source version, the upgrade assessment cannot be performed.")
    
    #获取R版本和C版本信息
    curCVersionTmp = curVer[0:11]
    upgCVersionTmp = destVer[0:11]
    #TR5可能为空
    curSPCVersionTmp = curVer[11:]
    upgSPCVersionTmp = destVer[11:]    
    
            
    #有效性检查（3）：判断是否为回退
    #非回退检查
    rollbackFlag = False        
    #当前C版本大于目标C版本则提示不支持回退检查
    if curCVersionTmp > upgCVersionTmp:
        funFlag = CheckedResult.NOTPASS
        rollbackFlag = True
    #C版本相同
    elif curCVersionTmp == upgCVersionTmp:
        #当前SPC号大于目标SPC号则提示不支持回退检查
        if curSPCVersionTmp > upgSPCVersionTmp:
            funFlag = CheckedResult.NOTPASS
            rollbackFlag = True
    if rollbackFlag:
        if lang == "zh":
            funErrMsg.append(u"工具只支持版本间升级的评估，不支持版本间回退的评估。")
        else:
            funErrMsg.append("The tool supports the assessment for version upgrade only. The rollback between versions cannot be assessed.")
    return funFlag, funErrMsg

