# -*- coding: UTF-8 -*-

import java.util.regex.Pattern as Jpattern

class Regex():
    IGNORECASE = Jpattern.CASE_INSENSITIVE
    VERBOSE = Jpattern.COMMENTS
    MULTILINE = Jpattern.MULTILINE
    DOTALL = Jpattern.DOTALL
    UNICODE = Jpattern.UNICODE_CASE
    
    @staticmethod
    def find(regex, s, flags=0, startPos=0):
        '''
        @summary: 返回正则表达式匹配是否成功
        @param regex: 正则表达式
        @param s: 要匹配的字符串
        @return: 
            True: 匹配成功
            False: 匹配失败
        '''
        reg = Jpattern.compile(regex, flags) 
        match = reg.matcher(s)
        if match.find(startPos):
            return True
        else:
            return False
    
    @staticmethod
    def search(regex, s, flags=0, startPos=0):
        '''
        @summary: 使用正则表达式匹配，返回匹配的结果
        @param regex: 正则表达式
        @param s: 要匹配的字符串
        @return: 匹配的结果
        '''
        reg = Jpattern.compile(regex, flags) 
        match = reg.matcher(s)
        if match.find(startPos):
            return match
        else:
            return None
    
    @staticmethod
    def getStartEndList(regex, s, flags=0):
        '''
        @summary: 使用正则表达式匹配，返回所有匹配结果的开始结尾字典
        @param regex: 正则表达式
        @param s: 要匹配的字符串
        @return: 所有匹配字符串的开头结尾list
        '''
        reg = Jpattern.compile(regex, flags) 
        match = reg.matcher(s)
        tuple_idxs = []
        while(match.find()):
            tuple_idxs.append((match.start(), match.end()))
        
        return tuple_idxs
    
    @staticmethod
    def split(regex, s, flags=0):
        '''
        @summary: 使用正则表达式匹配进行划分，返回spilt结果
        @param regex: 正则表达式
        @param s: 要匹配的字符串
        @return matchList: 匹配到的字符串list
                 spiltList:正则表达式spilt后的结果
        '''
        reg = Jpattern.compile(regex, flags) 
        match = reg.matcher(s)
        
        matchList = []
        while(match.find()):
            matchList.append(match.group())
        spiltList = reg.split(s);
        
        return (matchList, spiltList)
        
    @staticmethod
    def replaceAll(regex, s, replacement, flags=0, startPos=0):
        '''
        @summary: 使用给定的 replacement 替换此字符串所有匹配给定的正则表达式的子字符串。
        @param regex: 正则表达式
        @param s: 要匹配的字符串
        @param replacement: 要替换的字符串
        @return: 替换后生成的字符串
        '''    
        reg = Jpattern.compile(regex, flags) 
        match = reg.matcher(s)
        return match.replaceAll(replacement)
        


class RegPattern():
    '''
    @summary: regular expression pattern
    '''
    IPV4 = '((\d{1}|[1-9]\d{1}|1\d{2}|2[0-4]\d|25[0-5])\.){3}(\d{1}|[1-9]\d{1}|1\d{2}|2[0-4]\d|25[0-5])'
    