# -*- coding: UTF-8 -*-

MESSAGES_DICT = {
"no.support.publickey.forensics":
    {
        "zh": u"\n当前使用了用户名密码和PublicKey鉴权方式，不支持心跳到其他控制器执行检查，请修改鉴权方式为用户名密码鉴权后再执行检查。",
        "en": "\nAccount/Password authentication and public key authentication are used. You cannot log in to other controllers through heartbeat connection to perform a check. Change the authentication mode to account/password authentication, and then perform the check again."
    },
"user.authority.failure":
    {
        "zh":u"当前登录用户级别不是超级管理员，请使用超级管理员用户重新登录。",
        "en":"The current login user is not a super administrator. Please re-log in as a super administrator.",
    },
"unsupport.single.online":
    {
        "zh":u"单控模式不支持升级评估。",
        "en":"Single-Controller does not support upgrade evaluation." ,
    },
"unsupport.upgrade.path":
    {
        "zh":u"当前版本不支持升级评估到目标版本。",
        "en":"The tool does not support the evaluation path." ,
    },
"show.problems":
    {
        "zh":u"【问题%s】:\n%s\n\n",
        "en":"[Problem %s]:\n%s\n\n" ,
    },
"system.status.abnormal":
    {
        "zh":u"系统状态异常。",
        "en":"The system is abnormal." ,
    },
"target.version.not.exist":
    {
        "zh":u"升级目标版本号为空，不能执行检查，请重新输入。",
        "en":"The target version is left empty and the upgrade evaluation cannot be performed. Enter a target version. " ,
    },
"original.equal.to.target":
    {
        "zh":u"当前版本与目标版本相同，不能执行评估，请重新输入。",
        "en":"The target version is the same as the current version and the upgrade evaluation cannot be performed. Enter a target version. " ,
    },
"cannot.get.version":
    {
        "zh":u"无法获取产品版本信息。",
        "en":"Cannot get information about product version." ,
    },
"original.less.to.target":
    {
        "zh":u"工具只支持版本间升级的评估，不支持版本间回退的评估。",
        "en":"The tool supports the assessment for version upgrade only. The rollback between versions cannot be assessed." ,
    },
"need.refresh.device":
    {
        "zh":u"设备当前版本为%s，工具保存的设备版本为%s，请关闭当前子工具并在工具设备管理界面重新添加或更新设备。",
        "en":"The current version of the device is %s but that in the tool is %s. Close the current subtool and add the device again or refresh the device in the device management interface of the tool." ,
    },

"check.pass":
    {
        "zh":u"\n系统检查通过",
        "en":"\nSystem check pass",
    },
"query.result.abnormal":
    {
        "zh":u"\n获取信息失败",
        "en":"\nThere is an error in getting information",
    },
"cannot.get.system.info":
    {
        "zh":u"\n无法获取系统信息",
        "en":"\nCannot get information about system",
    },
"cannot.get.product.version.info":
    {
        "zh":u"\n无法获取产品版本信息",
        "en":"\nCannot get information about product version",
    },
"cannot.get.controller.info":
    {
        "zh":u"\n无法获取控制器信息",
        "en":"\nCannot get information about controller",
    },
"cannot.get.enclosure.info":
    {
        "zh":u"\n无法获取机框信息",
        "en":"\nCannot get information about enclosure",
    },
"cannot.get.bbu.info":
    {
        "zh":u"\n无法获取BBU信息",
        "en":"\nCannot get information about BBU",
    },
"cannot.get.bbu.config":
    {
        "zh":u"\n无法获取BBU规格",
        "en":"\nCannot get information about BBU specification",
    },
"cannot.get.remaining.lifetime.info":
    {
        "zh":u"\n无法获取BBU的生命剩余时间信息",
        "en":"\nCannot get information about lifespan of BBU",
    },
"cannot.get.bbu.remaining.lifetime":
    {
        "zh":u"\n无法获取BBU[%s]的生命剩余时间信息",
        "en":"\nCannot get information about lifespan of BBU [%s]",
    },
"cannot.get.fan.info":
    {
        "zh":u"\n无法获取风扇信息",
        "en":"\nCannot get information about fan",
    },
"cannot.get.fan.config":
    {
        "zh":u"\n无法获取风扇规格",
        "en":"\nCannot get information about fan specification",
    },
"cannot.get.power.supply.info":
    {
        "zh":u"\n无法获取电源信息",
        "en":"\nCannot get information about power supply",
    },
"cannot.get.fibre.module.info":
    {
        "zh":u"\n无法获取光模块信息",
        "en":"\nCannot get information about optical module",
    },
"cannot.get.port.info":
    {
        "zh":u"\n无法获取%s端口信息",
        "en":"\nCannot get information about %s port",
    },
"cannot.get.port.working.rate":
    {
        "zh":u"\n无法获取%s端口[%s]速率",
        "en":"\nCannot get working rate of %s port [%s]",
    },
"cannot.get.disk.info":
    {
        "zh":u"\n无法获取磁盘状态信息",
        "en":"\nCannot get information about disk status",
    },
"cannot.get.used.hot.spare.capacity.info":
    {
        "zh":u"\n无法获取POOL[%s]的hotspare容量信息",
        "en":"\nCannot get information about hotspare capacity of POOL [%s]",
    },
"cannot.get.link.info":
    {
        "zh":u"\n无法获取%s链路信息",
        "en":"\nCannot get information about %s link",
    },
"cannot.get.disk.domain.info":
    {
        "zh":u"\n无法获取硬盘域信息",
        "en":"\nCannot get information about disk domain",
    },
"cannot.get.lun.info":
    {
        "zh":u"\n无法获取LUN信息",
        "en":"\nCannot get information about LUN",
    },
"cannot.get.lun.copy.info":
    {
        "zh":u"\n无法获取LUN拷贝信息",
        "en":"\nCannot get information about LUN copy",
    },
"cannot.get.lun.migration.info":
    {
        "zh":u"\n无法获取LUN迁移信息",
        "en":"\nCannot get information about LUN migration",
    },
"cannot.get.snapshot.info":
    {
        "zh":u"\n无法获取快照信息",
        "en":"\nCannot get information about snapshot",
    },
"cannot.get.clone.info":
    {
        "zh":u"\n无法获取克隆信息",
        "en":"\nCannot get information about clone",
    },
"cannot.get.remote.replication.info":
    {
        "zh":u"\n无法获取远程复制信息",
        "en":"\nCannot get information about remote replication",
    },
"cannot.get.consistency.group.info":
    {
        "zh":u"\n无法获取一致性组信息",
        "en":"\nCannot get information about consistency group",
    },
"cannot.get.remote.lun.info":
    {
        "zh":u"\n无法获取远端LUN信息",
        "en":"\nCannot get information about remote LUN",
    },
"cannot.get.alarm.info":
    {
        "zh":u"\n无法获取告警信息",
        "en":"\nCannot get information about alarm",
    },
"controller.health.status.abnormal":
    {
        "zh":u"\n控制器[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of controller [%s] is abnormal (Health Status:%s)",
    },
"controller.running.status.abnormal":
    {
        "zh":u"\n控制器[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of controller [%s] is abnormal (Running Status:%s)",
    },
"controller.status.abnormal":
    {
        "zh":u"\n控制器[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of controller [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },
"enclosure.health.status.abnormal":
    {
        "zh":u"\n框[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of enclosure [%s] is abnormal (Health Status:%s)",
    },
"enclosure.running.status.abnormal":
    {
        "zh":u"\n框[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of enclosure [%s] is abnormal (Running Status:%s)",
    },
"enclosure.status.abnormal":
    {
        "zh":u"\n框[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of enclosure [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },
"power.supply.health.status.abnormal":
    {
        "zh":u"\n电源[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of power supply [%s] is abnormal (Health Status:%s)",
    },
"power.supply.running.status.abnormal":
    {
        "zh":u"\n电源[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of power supply [%s] is abnormal (Running Status:%s)",
    },
"power.supply.status.abnormal":
    {
        "zh":u"\n电源[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of power supply [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },
"bbu.status.abnormal":
    {
        "zh":u"\nBBU[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of BBU [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },
"fan.health.status.abnormal":
    {
        "zh":u"\n风扇[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of fan [%s] is abnormal (Health Status:%s)",
    },
"fan.running.status.abnormal":
    {
        "zh":u"\n风扇[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of fan [%s] is abnormal (Running Status:%s)",
    },
"fan.status.abnormal":
    {
        "zh":u"\n风扇[%s]状态异常(健康状态：%s，运行状态：%s)",
        "en":"\nThe status of fan [%s] is abnormal (Health Status:%s,Running Status:%s)",
    },
"disk.health.mark.abnormal":
    {
        "zh":u"\n硬盘[%s]健康状态异常(Health Mark：%s)",
        "en":"\nThe health mark of disk [%s] is abnormal (Health Mark:%s)",
    },
"disk.status.abnormal":
    {
        "zh":u"\n磁盘[%s]状态异常",
        "en":"\nThe status of disk [%s] is abnormal",
    },
"dataswitch.health.status.abnormal":
    {
        "zh":u"\n交换机[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of data switch [%s] is abnormal (Health Status:%s)",
    },
"dataswitch.running.status.abnormal":
    {
        "zh":u"\n交换机[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of data switch [%s] is abnormal (Running Status:%s)",
    },
"port.fibre.module.health.status.abnormal":
    {
        "zh":u"\n端口[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of port [%s] is abnormal (Health Status:%s)",
    },
"port.health.status.abnormal":
    {
        "zh":u"\n%s端口[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of %s port [%s] is abnormal (Health Status:%s)",
    },
"sas.port.running.status.abnormal":
    {
        "zh":u"\nSAS端口[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of SAS port [%s] is abnormal (Running Status:%s)",
    },
"lun.status.abnormal":
    {
        "zh":u"\nLUN[%s]状态异常",
        "en":"\nThe status of LUN [%s] is abnormal",
    },
"lun.copy.health.status.abnormal":
    {
        "zh":u"\nLUN拷贝[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of LUN copy [%s] is abnormal (Health Status:%s)",
    },
"snapshot.health.status.abnormal":
    {
        "zh":u"\n快照[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of snapshot [%s] is abnormal (Health Status:%s)",
    },
"lun.migration.running.status.abnormal":
    {
        "zh":u"\nLUN迁移[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of LUN migration [%s] is abnormal (Running Status:%s)",
    },
"clone.health.status.abnormal":
    {
        "zh":u"\n克隆[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of clone [%s] is abnormal (Health Status:%s)",
    },
"remote.replication.health.status.abnormal":
    {
        "zh":u"\n远程复制[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of remote replication [%s] is abnormal (Health Status:%s)",
    },
"consistency.group.health.status.abnormal":
    {
        "zh":u"\n一致性组[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of consistency group [%s] is abnormal (Health Status:%s)",
    },
"port.working.rate.abnormal":
    {
        "zh":u"\n%s端口[%s]工作速率异常(速率：%sMbps)",
        "en":"\nThe working rate of %s port [%s] is abnormal (Working Rate:%sMbps)",
    },
"engine.may.be.offline":
    {
        "zh":u"\n引擎[%s]存在无法监控的控制器",
        "en":"\nEngine [%s] has controllers that cannot be monitored.",
    },
"fan.number.not.enough":
    {
        "zh":u"\n框[%s]存在风扇个数不足(满配个数：%s，实际个数：%s)",
        "en":"\nThe number of fans in the enclosure [%s] is insufficient (Required Number:%s, Current Number:%s)",
    },
"bbu.number.not.enough":
    {
        "zh":u"\n引擎[%s]存在BBU个数不足(满配个数：%s，实际个数：%s)",
        "en":"\nThe number of BBUs in the engine [%s] is insufficient (Required Number:%s, Current Number:%s)",
    },
"bbu.remaining.lifetime.abnormal":
    {
        "zh":u"\nBBU[%s]的生命剩余时间小于%s天(生命剩余时间：%s天)",
        "en":"\nThe remaining lifetime of BBU [%s] is less than [%s] days (Remaining Lifetime:%sdays)",
    },
"pcie.switch.number.not.enough":
    {
        "zh":u"\nPCIe交换机个数不足",
        "en":"\nThe number of PCIe switches is insufficient",
    },
"sas.port.link.none.symmetrical":
    {
        "zh":u"\nSAS端口[%s]连接异常，与端口[%s]连接不对称",
        "en":"\nThe SAS port [%s] is improperly connected and is not symmetrical with port [%s]",
    },
"engine.zero.circle.not.connected":
    {
        "zh":u"\n引擎环路0未连接",
        "en":"\nLoop 0 of the engine is not connected",
    },
"engine.zero.circle.connect.abnormal":
    {
        "zh":u"\n引擎环路0必须连接，SAS端口[%s]未连接",
        "en":"\nLoop 0 of the engine must be connected. The SAS port [%s] is disconnected",
    },
"pool.used.hot.spare.capacity.abnormal":
    {
        "zh":u"\n硬盘域[ID:%s]的已使用Hotspare容量大于0(容量:%s)",
        "en":"\nThe used hot spare capacity of disk domain [ID:%s] is more than 0 (Capacity:%s)",
    },
"remote.lun.path.status.abnormal":
    {
        "zh":u"\n远端LUN路径状态异常",
        "en":"\nThe path status of remote LUN is abnormal",
    },
"check.result.timeout":
    {
        "zh":u"\n控制器[%s]:检查结果超时",
        "en":"\nController [%s]: The check times out.",
    },

"check.reserved.memory.notpass":
    {
        "zh":u"\n控制器[%s]:系统预留内存空间不足：",
        "en":"\nThe reserved memory of controller [%s] is insufficient.",
    },
"check.reserved.memory.pass":
    {
        "zh":u"\n控制器[%s]:系统预留内存空间充足：",
        "en":"\nThe reserved memory of controller [%s] is enough. The upgrade can be performed.",
    },
"check.syssoftware.compatible.notpass":
    {
        "zh":u"\n控制器[%s]:系统软件不兼容",
        "en":"\nSystem software of controller [%s] is imcompatible",
    },
"check.syssoftware.compatible.pass":
    {
        "zh":u"\n控制器[%s]:系统版本兼容",
        "en":"\nSystem software of controller [%s] is compatible",
    },
"check.fwversion.compatible.pass":
    {
        "zh":u"\n控制器[%s]:固件版本兼容",
        "en":"\nThe firmware version of controller [%s] is compatible",
    },
"check.fwversion.compatible.notpass":
    {
        "zh":u"\n控制器[%s]:固件版本不兼容",
        "en":"\nThe firmware version of controller [%s] is imcompatible",
    },
"check.system.status.notpass":
    {
        "zh":u"\n系统状态异常",
        "en":"\nCannot perform the upgrade because the system is abnormal",
    },
"check.system.status.pass":
    {
        "zh":u"\n系统状态正常",
        "en":"\nThe system is normal",
    },
"check.system.resource.notpass":
    {
        "zh":u"\n控制器[%s]:系统CPU利用率或者内存空间不足",
        "en":"\nCannot perform the upgrade because system resources (CPU or Memory) of controller [%s] are insufficient",
    },

"check.system.resource.pass":
    {
        "zh":u"\n控制器[%s]:系统资源充足",
        "en":"\nSystem resources of controller [%s] meet the upgrade requirements",
    },
"check.system.pressure.notpass":
    {
        "zh":u"\n系统负载过大",
        "en":"\nThe current system operation load is heavy.",
    },
"check.system.pressure.pass":
    {
        "zh":u"\n系统负载正常",
        "en":"\nThe system operation load check is passed.",
    },
"check.version.consistance.notpass":
    {
        "zh":u"\n控制器间系统版本不一致",
        "en":"\nController versions are inconsistent.",
    },
"check.version.consistance.pass":
    {
        "zh":u"\n所有控制器系统版本一致",
        "en":"\nAll controller versions are consistent.",
    },
"check.double.controller.notpass":
    {
        "zh":u"\n控制器[%s]:为单控状态",
        "en":"\n[%s] is single controller.",
    },
"check.double.controller.pass":
    {
        "zh":u"\n控制器[%s]所在引擎的pair对为双控",
        "en":"\nThe engine of controller [%s] lies in has dual controllers.",
    },
"check.xnet.pressure.notpass":
    {
        "zh":u"\n控制器[%s]:Xnet压力过大",
        "en":"\nThe xnet service of controller [%s] is busy.",
    },
"check.xnet.pressure.pass":
    {
        "zh":u"\n控制器[%s]:Xnet压力正常",
        "en":"\nThe xnet pressure of controller [%s] check is passed.",
    },
"check.system_config.log.notpass":
    {
        "zh":u"\n系统配置日志没有结束",
        "en":"\nSystem configurations are not completed.",
    },
"check.system_config.log.pass":
    {
        "zh":u"\n系统配置日志检查通过",
        "en":"\nPass.",
    },
"check.front.pressure.notpass":
    {
        "zh":u"\n控制器[%s]:前端压力过大",
        "en":"\nFront-end pressure of controller [%s] does not meet the requirements.",
    },
"check.front.pressure.pass":
    {
        "zh":u"\n控制器[%s]:前端压力检查通过",
        "en":"\nFront-end pressure of controller [%s] meets the upgrade requirements.",
    },
"check.system.alarm.notpass":
    {
        "zh":u"\n系统存在紧急或重要告警",
        "en":"\nCritical or major alarms exist",
    },
"check.system.alarm.pass":
    {
        "zh":u"\n系统不存在紧急或者重要告警",
        "en":"\nNo alarms of the critical or major severity exist",
    },
"check.disk.usage.notpass":
    {
        "zh":u"\n控制器[%s]:磁盘利用率过高",
        "en":"\nCannot perform the upgrade because the disk usage of controller [%s] is high.",
    },
"check.disk.usage.pass":
    {
        "zh":u"\n控制器[%s]:磁盘利用率检查通过",
        "en":"\nThe disk usage of controller [%s] is normal",
    },
"check.disk.slow.notpass":
    {
        "zh":u"\n系统存在慢盘",
        "en":"\nSlow disks are found and an upgrade cannot be performed.",
    },
"check.disk.slow.pass":
    {
        "zh":u"\n系统无慢盘",
        "en":"\nNo slow disks are found and an upgrade can be performed.",
    },
"check.diskdomain.status.notpass":
    {
        "zh":u"\n控制器[%s]:硬盘域状态不正常",
        "en":"\nController[%s]:The status of disk domain is abnormal.",
    },
"check.diskdomain.status.pass":
    {
        "zh":u"\n控制器[%s]:硬盘域状态正常",
        "en":"\nController[%s]:The status of disk domain is normal and an upgrade can be performed.",
    },
"check.extlunlink.status.notpass":
    {
        "zh":u"\n外部Lun链路状态异常",
        "en":"\nExtern lun is single link.",
    },
"check.extlunlink.status.pass":
    {
        "zh":u"\n外部Lun链路状态正常",
        "en":"\nExtern lun link is normal and an upgrade can be performed.",
    },
"check.lun.destroy.notpass":
    {
        "zh":u"\nLun销毁状态异常",
        "en":"\nCheck lun destroy notpass.",
    },
"check.disk.singlelink.notpass":
    {
        "zh":u"\n控制器[%s]:磁盘单链路检查不通过，不允许升级",
        "en":"\nDisk single link of controller [%s] check not pass, upgrade can not be performed.",
    },
"check.disk.singlelink.pass":
    {
        "zh":u"\n控制器[%s]:磁盘单链路检查通过",
        "en":"\nThe disk single link of controller [%s] check pass.",
    },
"check.disk.isDiskInDiagnose.notpass":
    {
        "zh":u"\n控制器[%s]:有硬盘在线诊断,不允许升级",
        "en":"\nCannot perform the upgrade because disks of controller [%s] are being diagnosed online.",
    },
"check.disk.isDiskInDiagnose.pass":
    {
        "zh":u"\n控制器[%s]:没有硬盘在线诊断",
        "en":"\nNo disks of controller [%s] are being diagnosed online.",
    },
"check.hardware.BBUPower.notpass":
    {
        "zh":u"\n控制器[%s]:BBU电量不足",
        "en":"\nThe BBU of controller [%s] has insufficient amount of electricity.",
    },
"check.hardware.BBUPower.pass":
    {
        "zh":u"\n控制器[%s]:BBU电量充足",
        "en":"\nThe BBU of controller [%s] has sufficient amount of electricity.",
    },
"check.hardware.PCIESingleLink.notpass":
    {
        "zh":u"\n链路异常，不允许升级",
        "en":"\nThe link is abnormal. The upgrade cannot be performed.",
    },
"check.hardware.PCIESingleLink.pass":
    {
        "zh":u"\n链路正常，允许升级",
        "en":"\nThe link is normal. The upgrade can be performed.",
    },
"check.frontlink.pass":
    {
        "zh":u"\n控制器[%s]:前端链路冗余",
        "en":"\nController [%s]: There are redundant front-end links.",
    },
"check.frontlink.notpass":
    {
        "zh":u"\n控制器[%s]:前端链路不冗余",
        "en":"\nController [%s]: There are no redundant front-end links.",
    },
"check.frontlink.result.nopass":
    {
        "zh":u"\n前端链路不冗余，不冗余的主机ID为：%s",
        "en":"\nThere are no redundant front-end links. The ID of the host that is not redundant is %s.",
    },
"check.frontlink.result.queryInfoError":
    {
        "zh":u"\n无法获取信息的主机ID为：%s",
        "en":"\nFailed to obtain the information of front-end links. The ID of the host is %s.",
    },
"check.frontlink.result.noOnlineInitiator":
    {
        "zh":u"\n启动器状态不在线的主机ID为：%s",
        "en":"\nThe status of initiator is not online. The ID of the host is %s",
    },
"check.frontlink.result.noSupportIbLink":
    {
        "zh":u"\n以下主机无法获取到IB启动器的前端链路信息：%s",
        "en":"\nFailed to obtain the front-end links information of ib initiator. The ID of the host is %s",
    },

"DiskDomainPossessionCheck.notpass":
    {
        "zh":u"\n硬盘域保有量设置过小，检查不通过，不支持升级",
        "en":"\nCan not perform upgrade because disk domain possession is set too small and the check is not passed.",
    },
"DiskDomainPossessionCheck.pass":
    {
        "zh":u"\n硬盘域保有量检查通过，可以进行升级操作。",
        "en":"\nDisk domain possession check is passed and upgrade can be performed.",
    },
"LUNPossessionCheck.notpass":
    {
        "zh":u"\nLUN保有量设置过小，检查不通过，不支持升级",
        "en":"\nCan not perform upgrade because LUN possession is set too small and the check is not passed.",
    },
"LUNPossessionCheck.pass":
    {
        "zh":u"\nLUN保有量检查通过，可以进行升级操作。",
        "en":"\nLUN possession check is passed and upgrade can be performed.",
    },
"check.vm.machine.shutdown.notpass":
    {
        "zh":u"\n当前控制器（%s）上有虚拟机处于未关闭状态，请关闭后再重试。",
        "en":"\nSome virtual machine (%s) is not shut off. Make sure all virtual machine is shut off and retry.",
    },
"check.vm.machine.shutdown.pass":
    {
        "zh":u"\n所有虚拟机是否关闭检测通过。",
        "en":"\nWhether all virtual machine shut off check is passed.",
    },
"cannot.get.quorum.server.link.info":
    {
        "zh":u"\n无法获取双活仲裁链路状态信息",
        "en":"\nFailed to obtain the status of active-active quorum links.",
    },
"quorum.server.link.status.abnormal":
    {
        "zh":u"\n双活仲裁服务器[%s]链路状态异常(链路状态：%s)",
        "en":"\nThe status of the links to active-active quorum server [%s] is abnormal (link status: %s).",
    },
"cannot.get.quorum.server.info":
    {
        "zh":u"\n无法获取双活仲裁服务器运行状态信息",
        "en":"\nFailed to obtain the running status of the active-active quorum server.",
    },
"quorum.server.running.status.abnormal":
    {
        "zh":u"\n双活仲裁服务器[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of active-active quorum server [%s] is abnormal (running status: %s).",
    },
"cannot.get.hyper.metro.domain.info":
    {
        "zh":u"\n无法获取双活域运行状态信息",
        "en":"\nFailed to obtain the running status of the active-active domain.",
    },
"hyper.metro.domain.running.status.abnormal":
    {
        "zh":u"\n双活域[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of active-active domain [%s] is abnormal (running status: %s).",
    },
"cannot.get.hyper.consist.group.info":
    {
        "zh":u"\n无法获取双活一致性组状态信息",
        "en":"\nFailed to obtain the information about the status of the active-active consistency groups.",
    },
"hyper.consist.group.health.status.abnormal":
    {
        "zh":u"\n双活一致性组[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of active-active consistency group [%s] is abnormal (health status: %s).",
    },
"hyper.consist.group.running.status.abnormal":
    {
        "zh":u"\n双活一致性组[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of active-active consistency group [%s] is abnormal (running status: %s).",
    },
"cannot.get.hyper.metro.pair.info":
    {
        "zh":u"\n无法获取双活Pair状态信息",
        "en":"\nFailed to obtain the status of the active-active pair.",
    },
"hyper.metro.pair.health.status.abnormal":
    {
        "zh":u"\n双活Pair[%s]健康状态异常(健康状态：%s)",
        "en":"\nThe health status of active-active pair [%s] is abnormal (health status: %s).",
    },
"hyper.metro.pair.link.status.abnormal":
    {
        "zh":u"\n双活Pair[%s]链路状态异常(链路状态：%s)",
        "en":"\nThe link status of active-active pair [%s] is abnormal (link status: %s).",
    },
"hyper.metro.pair.running.status.abnormal":
    {
        "zh":u"\n双活Pair[%s]运行状态异常(运行状态：%s)",
        "en":"\nThe running status of active-active pair [%s] is abnormal (running status: %s).",
    },
"check.eth.port.ip.notpass":
    {
        "zh":u"\n主机端口IP配置存在升级兼容性隐患，请联系技术支持工程师协助处理。",
        "en":"\nCompatibility issues may occur during the IP address configuration of host ports. contact technical support engineers for help. ",
    },
"check.protocol.notpass":
    {
        "zh":u"\n检查到有不支持在线升级的NAS协议业务连接系统。",
        "en":"\nServices using NAS protocols that do not support online upgrade are detected.",
    },
"check.protocol.pass":
    {
        "zh":u"\n系统文件共享服务检查通过。",
        "en":"\nThe system file sharing service check is passed.",
    },

"cannot.get.heterogeneous.link.info":
    {
        "zh":u"\n无法获取异构链路信息。",
        "en":"\nObtaining heterogeneous link information fails.",
    },
"check.heterogeneous.link.status.init":
    {
        "zh":u"\n异构链路SESSION状态异常（状态：%s）。",
        "en":"\nThe SESSION status (status: %s) of heterogeneous links is abnormal.",
    },
"cannot.create.controller.cli":
    {
        "zh":u"\n无法连接该控制器，无法执行检查。",
        "en":"\nFailed to connect to the controller; therefore, the check cannot be performed.",
    },
"query.controller.result.abnormal":
    {
        "zh":u"\n获取控制器信息失败。",
        "en":"\nThere is an error in getting controller information",
    },
"Nfsshared.check.notpass":
    {
        "zh":u"\nNFS共享服务异常。",
        "en":"\nNFS sharing service is abnormal.",
     } ,
"IPv6LockService.notpass":
    {
        "zh":u"\n当前设备存在IPV6配置，检查不通过。",
        "en":u"\nCurrent device has been configured IPV6 and the check is not passed.",
     },
"check.ipv6.exist.notpass":
    {
        "zh":u"\niSNS服务配置了IPv6地址，不支持升级。",
        "en":"\nCan not perform upgrade because an IPv6 address has been configured for an iSNS server.",
    },
"check.io.status.notpass":
    {
        "zh":u"\nIO状态异常。",
        "en":"\nThe IO status is abnormal.",
    },
"check.cache.fault.notpass":
    {
        "zh":u"\ncache分区[%s]存在fault页面。",
        "en":"\nThe cache partition[%s] exist fault pages",
    },
"cli.result.is.invalid":
    {
        "zh":u"\n无效CLI信息。",
        "en":"\nInvalid Cli information.",
    },
"title.controller":
    {
        "zh":u"\n控制器[%s]： ",
        "en":"\nController[%s]: ",
    },
"cannot.ctrl.id.ip":
    {
        "zh":u"\n获取控制器信息失败。 ",
        "en":"\nThere is an error in getting controller information.",
    },
"enterDeveloperMode.failure":
    {
        "zh":u"\n进入developer模式失败。",
        "en":"\nEnter the developer mode failure."
     },
"check.diskDomainFaultStatus.notpass":
    {
        "zh":u"\nDiskDomain故障，请修复告警[%s]。",
        "en":"\nDiskDomain is faulty, please repair alarm[%s]"
     },
"exist.risk.versionPath":
    {
        "zh":u"\n当前升级路径存在风险。",
        "en":"\nThe current upgrade path exist risk."
     },
"controller.check.pass":
    {
        "zh":u"\n检查通过。",
        "en":"\nCheck pass."
    },
"inner.ip.not.continuity":
    {
        "zh":u"\n内部ip不连续。",
        "en":"\nDiscontinuous internal IP addresses."
    },
"inner.ip.cotroller.fault":
    {
        "zh":u"\n存在控制器故障，请修复后再进行该检查项。",
        "en":"\nA controller fault exists. Rectify the fault and then check the item."
    },
"inner.ip.manual.check":
    {
        "zh":u"\n当前产品版本(%s)不能工具化检查，请根据修复建议参考案例手动检查。",
        "en":"\nThe current product version ( %s ) does not support check by tool. See the troubkeshooting case to manually execute check based on the recommended actions."
    },
"install.onlyone.hotpatch":
    {
        "zh":u"\n请安装%s热补丁。",
        "en":"\nInstall the %s hot patch.",
    },
"install.many.hotpatch":
    {
        "zh":u"\n请依次安装%s热补丁。",
        "en":"\nInstall the %s hot patches in sequence.",
    },
"needInstallHotPatch.result.notPatchset.notX99":
    {
        "zh":u"\n1、请登录support网站（%s），搜索当前产品型号，进入'软件'下载界面。\n2、选择并下载相应补丁包和补丁安装指导书，参考补丁安装指导书安装%s的补丁。",
        "en":"\n1. Log in to the Huawei support website (%s) and search for the product model to go to the Software download page. \n2. Select and download the required patch package and patch installation guide. Install the patch of %s by referring to the patch installation guide. ",
    },
"needInstallHotPatch.result.notPatchset.isX99":
    {
        "zh":u"\n1、请登录support网站（%s），搜索当前产品型号，进入'软件'下载界面。\n2、选择并下载相应补丁包和补丁安装指导书，参考补丁安装指导书'补丁回退'章节回退补丁，再安装%s的补丁。",
        "en":"\n1. Log in to the Huawei support website (%s) and search for the product model to go to the Software download page. \n2. Select and download the required patch package and patch installation guide. For details, see section 'Rolling Back the Patch Installation' of the patch installation guide. Install the patch of %s. ",
     },
"needInstallHotPatch.result.isPatchset.notX99":
    {
        "zh":u"\n1、请从网站地址（%s）下载补丁压缩包，从压缩包中解压获取%s的补丁。\n2、参考补丁安装指导书安装%s的补丁。",
        "en":"\n1. Download the patch package from the address (%s), and decompress the patch package to obtain the patch of %s. \n2. Install the patch of %s by referring to the patch installation guide. ",
     },
"needInstallHotPatch.result.isPatchset.isX99":
    {
        "zh":u"\n1、请从网站地址（%s）下载补丁压缩包，从压缩包中解压获取%s的补丁。\n2、参考补丁安装指导书'补丁回退'章节回退补丁，再安装%s的补丁。",
        "en":"\n1. Download the patch package from the address (%s), and decompress the patch package to obtain the patch of %s. \n2. Roll back the patch by referring to section 'Rolling Back the Patch Installation' of the patch installation guide, and then install the patch of %s. ",
     },
"hotpatch.version.later":
    {
        "zh":u"或以后版本",
        "en":" or a later version",
     },
"install.patch.hotpatch":
    {
        "zh":u"或以后版本",
        "en":" or a later version",
     },
"comma.res":
    {
        "zh":u"，",
        "en":",",
    },
"check.io.detect.notpass":
    {
        "zh":u"\n当前系统有IO挂起。",
        "en":"\nSome IOs are suspended in the current system.",
    },
"download.config.file.failed":
    {
        "zh":u"\n导出运行数据文件失败。",
        "en":"\nFailed to export the running data file."
    },
"analyze.xml.failed":
    {
        "zh":u"\n读取规则文件失败。",
        "en":"\nFailed to read the rule file."
    },
"queryitem.not.in.xml":
    {
        "zh":u"\n规则文件未配置该检查项。",
        "en":"\nThis check item is not configured for the rule file."
    },
"not.match.rule":
    {
        "zh":u"\n表[%s]中%s为%s时: %s数据项的'%s'值状态异常。",
        "en":"\nIn table [%s] which %s is %s: In data item %s the value of '%s' is abnormal."
    },
"nooutput.not.match.rule":
    {
        "zh":u"\n表[%s]: %s数据项的'%s'值状态异常。",
        "en":"\nIn table [%s]: In data item %s the value of '%s' is abnormal."
    },
"analyze.query.result.abnormal":
    {
        "zh":u"\n获取信息失败,请联系技术支持工程师进行处理。",
        "en":"\nThere is an error in getting information, contact technical support engineers.",
    },
"abnormal.data.content":
    {
        "zh":u"\n原始信息异常,请联系技术支持工程师进行处理。",
        "en":"\nAbnormal original information, contact technical support engineers.",
    },
"virtual.machine.service.starting":
    {
        "zh":u"\n虚拟机服务正在启动，请手动检查或稍后重试。",
        "en":"\nThe VM service is being started. Please manually perform the check or try again later.",
    },
"exist.unsupport.protocal":
    {
        "zh":u"\n控制器[%s]：存在不支持在线升级的%s连接。",
        "en":"\nController [%s]: %s connections that do not support online upgrade exist."
    },
"exist.ndmp.protocal":
    {
        "zh":u"\n存在不支持在线升级的NDMP连接。",
        "en":"\nNDMP connections that do not support online upgrade exist."
    },
"exist.check.alarm":
    {
        "zh":u"\n存在告警%s。",
        "en":"\nalarm %s exists.",
    },
"control.exist.cahce.fault":
    {
        "zh":u"\n控制器[%s]：存在cache分区fault页面。",
        "en":"\nController [%s]: The cache partition exist fault pages.",
    },
"remote.device.link":
    {
        "zh":u"\n%s链路中远端设备链路[%s]健康状态异常(健康状态：%s)",
        "en":"\nIn link %s, the health status of link %s of the peer-end device is abnormal (Health Status:%s)" ,
    },
"has.disk.romaing":
    {
        "zh":u"\n保险盘[LD:%s，SlotId:%s]存在漫游。",
        "en":"\nCoffer disks[LD:%s,SlotId:%s] roaming exists.",
    },
"get.result.abnormal":
    {
        "zh":u"\n查询结果异常。",
        "en":"\nQuery result is abnormal.",
    },
"disks.not.match":
    {
        "zh":u"\n不配套的硬盘位置信息如下：%s。",
        "en":"\nThe unmatched disks are in the following positions: %s.",
    },
"conf.enclosure.cable.alarm.error":
    {
        "zh":u"\n配置硬盘框接线错误，请修复相应告警[告警ID：%s]。",
        "en":"\nThe cabling of the configuration disk enclosure is not correct, please repair alarm[alarm ID:%s].",
    },
"zero.engine.check.pass":
    {
        "zh":u"\n引擎[0]：检查通过。",
        "en":"\nEngine [0]: The check is passed.",
    },
"engine.port.check.notpass":
    {
        "zh":u"\n引擎[%s]：端口%s未正确连接到配置硬盘框（对端当前连接：%s）。",
        "en":"\nEngine [%s]: Port %s is not correctly connected to the configuration disk enclosure (current connection on the peer device: %s).  ",
    },
"multi.engine.not.check":
    {
        "zh":u"\n引擎0外的其他引擎工具无法检查，请参考组网助手手动检查其他引擎与配置硬盘框是否为正接。",
        "en":"\nThe tool cannot check other engines except for engine 0. Manually check whether other engines are connected to the configuration disk enclosure in forward connection mode by referring to Huawei Storage Networking Assistant. ",
    },
"cannot.get.interface":
    {
        "zh":u"\n无法获取接口卡信息。",
        "en":"\nFailed to obtain information about interface modules.",
     },
"lasttwo.has.SASCard":
    {
        "zh":u"\n槽位【ID:%s】存在SAS接口卡，请根据修复建议进行处理。",
        "en":"\nA SAS interface module exists in Slot [ID:%s]. Please rectify faults based on handling suggestions.",
     },
"cannot.get.cofferdisk":
    {
        "zh":u"\n无法获取系统保险箱盘信息。",
        "en":"\nFailed to obtain information about coffer disks of the system.",
     },
"engine.allcoffer.4Kdisk":
    {
        "zh":u"\n框【ID:%s】中的保险箱盘均为4K盘，请参考修复建议进行处理。",
        "en":"\nCoffer disks in enclosure [ID:%s] are all 4 KB-sector disks. Please rectify faults based on handling suggestions.",
     },
"cannot.get.one.cofferdisk":
    {
        "zh":u"\n无法获取保险箱盘【ID:%s】信息。",
        "en":"\nFailed to obtain information about coffer disk [ID:%s].",
     },
"check.iops.abnormal":
    {
        "zh":u"\n系统存在镜像链路异常，请根据修复建议进行处理。",
        "en":"\nMirror link of the system is abnormal. Please rectify faults based on handling suggestions.",
     },
"check.iocounter.exist":
    {
        "zh":u"\n系统有业务存在，请根据修复建议进行处理。",
        "en":"\nServices exist in the system. Please rectify faults based on handling suggestions.",
     },
"check.iocounter.warning":
    {
        "zh":u"\n当前场景不支持带NAS业务升级，请停止NAS业务后再进行升级操作。",
        "en":"\nAn upgrade with the NAS service running is not supported in this scenario. Please stop the NAS service before the upgrade.",
     },
"check.ndmpAndSnapshotLicense.notpass":
    {
        "zh":u"\n已使用NDMP特性，缺少快照license，请根据修复建议进行处理。",
        "en":"\nNDMP is used but snapshot license is unavailable. Please handle the issue based on the suggestions. ",
     },
"check.iocInterfaceModule.ioc.notpass":
    {
        "zh":u"\n槽位[ID:%s]: 存在4x10GE 电接口模块,电子标签字段中Item等于%s。",
        "en":"\nSlot [ID:%s]: The 4x10GE Electrical Interface Module exists and the value of item is %s in the Electronic Label.",
     },
"check.iocInterfaceModule.smartio.notpass":
    {
        "zh":u"\n槽位[ID:%s]: 存在4端口 SmartIO I/O模块的运行模式为%s。",
        "en":"\nSlot [ID:%s]: The 4-port SmartIO I/O Module exists and the running mode is %s.",
     },
"check.2x10GEOpticalInterface.exist":
    {
        "zh":u"\n槽位【ID:%s】存在 2x10GE光接口模块，请根据修复建议进行处理。",
        "en":"\nSlot [ID:%s]: 2 x 10GE optical modules exist. Please handle the issue based on the suggestions.",
     },
"download.file.failed":
    {
        "zh":u"\n下载%s文件失败。",
        "en":"\nFailed to download file %s."
    },
"download.file.excption":
    {
        "zh":u"\n下载%s文件发生异常。",
        "en":"\nAn exception occurs when file %s is being downloaded."
    },
"delete.collect.file.failed":
    {
        "zh":u"\n删除远端%s文件失败。",
        "en":"\nFailed to delete file %s at the remote end."
    },
"coffer.disk.is.sata":
    {
        "zh":u"\n存在类型为SATA盘的保险箱盘（%s），请参考修复建议进行处理。",
        "en":"\nCoffer disks[%s] of SATA type exist. Please handle the issue based on the suggestions."
    },
"hyper.metro.pair.info.exists":
    {
        "zh":u"\n存在双活配置。",
        "en":"\nHyperMetro pair is configured.",
    },
"disk.fw.ver.early":
    {
        "zh":u"\n固件版本过低的硬盘ID如下：\n%s",
        "en":"\nIDs of disks whose firmware versions are too early are as follows: \n%s"
    },
"cannot.get.disk.fw.model.failed":
    {
        "zh":u"\n无法获取固件版本和Model的硬盘如下：\n%s",
        "en":"\nDisks whose firmware version and Model cannot be obtained are as follows: \n%s",
    },
"ibc.passwd.changed":
    {
        "zh":u"\nibc_os_hs账户密码不是默认密码。",
        "en":"\nThe password of account ibc_os_hs is not the default password.",
    },
"dif.module.verify.level.trace":
    {
        "zh":u"\nDIF_MID_VOLUME模块的校验级别为3。",
        "en":"\nThe value of the verify level parameter for the DIF_MID_VOLUME module is 3.",
    },
"cifs.share.conf.notpass":
    {
        "zh":u"\n当前CIFS共享配置可能导致业务中断。",
        "en":"\nThe current CIFS share configuration may cause service interruption.",
    },

"replication.upgrade.check.notpass":
    {
        "zh":u"\n远程复制从端可能会出现控制器复位的风险。",
        "en":"\nThe controllers on the secondary remote replication end may reset.",
    },
"intf.runMode.notpass":
    {
        "zh":u"\n疑似存在接口卡类型配置错误，可能导致升级失败。请使用信息收集工具收集日志并联系技术支持工程师分析。",
        "en":"\nThe interface module type is probably incorrect, which may lead to upgrade failure. Use the information collection tool to collect logs and contact technical support engineers.",
    },
"file.system.configured":
    {
        "zh":u"\n配置了文件系统。",
        "en":"\nFile systems have been configured.",
    },
"query.historyVersion.abnormal":
    {
        "zh":u"\n获取历史版本信息失败。",
        "en":"\nFailed to obtain the historical version.",
    },
"query.historyVersion.result.notpass":
    {
        "zh":u"\n历史版本（%s）检查不通过，升级存在风险。",
        "en":"\nHistorical version (%s) fails to pass the check, and there are risks for an upgrade.",
    },
"snapshot.write.mirror.status.not.check.as.license.file.missing":
    {
        "zh":u"\nLicense文件不存在，查询快照信息失败。若存储系统存在快照，则所有快照的cache镜像功能未检查，请导入License后重新检查；若存储系统不存在快照，请忽略此提示信息。",
        "en":"\nFailed to query the snapshot information because no license file exists. If there are snapshots in the system, the cache mirroring function of all snapshots are not checked. Import a license and check again. If there is no snapshot in the system, skip this prompt message."
    },
"all.lun.snapshot.write.mirror.plz.chk.further.ref.event.file":
    {
        "zh":u"\n请确认评估过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行评估。\n存储设备上所有的LUN和快照的Cache镜像状态开启，请联系技术工程师。",
        "en":"\nCheck whether a LUN migration or volume mirroring operation is going on during the assessment. If such an operation exists, wait for the operation to complete and retry the assessment.\nThe cache mirroring functions of the all LUNs and snapshots on the storage device is enabled, contact Huawei technical support engineers."
    },
"lun.not.mirror":
    {
        "zh":u"\n请确认评估过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行评估。\n存储设备上以下LUN的Cache镜像功能关闭， LUN ID为：\n%s",
        "en":"\nCheck whether a LUN migration or volume mirroring operation is going on during the assessment. If such an operation exists, wait for the operation to complete and retry the assessment.\nThe cache mirror functions of the following LUNs on the storage device are disabled. LUN IDs are:\n%s"
    },
"snapshot.not.mirror":
    {
        "zh":u"\n请确认评估过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行评估。\n存储设备上以下快照的Cache镜像功能关闭，快照存在风险，建议删除并重新创建快照， 快照 ID为：\n%s",
        "en":"\nCheck whether a LUN migration or volume mirroring operation is going on during the assessment. If such an operation exists, wait for the operation to complete and retry the assessment.\nThe cache mirroring functions of the following snapshots on the storage device are disabled. The snapshots have risks. You are advised to delete them and create new ones. Snapshot IDs are:\n%s"
    },
"lun.mirror.status.unknown":
    {
        "zh":u"\n存储设备上以下LUN的Cache镜像状态查询失败，请联系技术支持工程师协助处理。LUN ID为：\n%s",
        "en":"\nFailed to query the cache mirroring functions of the following LUNs on the storage device, please contact technical support engineers for help. LUN IDs are:\n%s"
    },
"snapshot.mirror.status.unknown":
    {
        "zh":u"\n存储设备上以下快照的Cache镜像状态查询失败，请联系技术支持工程师协助处理， 快照 ID为：\n%s",
        "en":"\nFailed to query the cache mirroring functions of the following snapshots on the storage device, please contact technical support engineers for help. Snapshot IDs are:\n%s"
    },
"lun.work.in.single.ctrl.mode":
    {
        "zh":u"\n请确认评估过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行评估。\n存储设备上以下LUN工作在单控模式，存在将LUN的Cache镜像功能由关闭更改为开启的操作。LUN ID为：\n%s",
        "en":"\nCheck whether a LUN migration or volume mirroring operation is going on during the assessment. If such an operation exists, wait for the operation to complete and retry the assessment.\nThe following LUNs on the storage device work in single-controller mode, and the cache mirroring states of the LUNs are changed from disabled to enabled. LUN IDs are:\n%s"
    },
"snapshot.work.in.single.ctrl.mode":
    {
        "zh":u"\n请确认评估过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行评估。\n存储设备上以下快照工作在单控模式，存在将快照的Cache镜像功能由关闭更改为开启的操作，快照存在风险，建议删除并重新创建快照， 快照 ID为：\n%s",
        "en":"\nCheck whether a LUN migration or volume mirroring operation is going on during the assessment. If such an operation exists, wait for the operation to complete and retry the assessment.\nThe following snapshots on the storage device work in single-controller mode, and the cache mirroring states of the snapshots are changed from disabled to enabled. The snapshots have risks. You are advised to delete them and create new ones. Snapshot IDs are:\n%s"
    },
"dev.connEngine.failure":
    {
        "zh":u"工具连接以下引擎失败，引擎编号为：%s。你可按以下方式处理：\n1 请恢复工具到编号为以下的引擎的连接：%s，然后重新检查。\n2 请参考预警公告CIT-P-S-201713中的附件《关于存储设备LUN的Cache镜像功能关闭后数据丢失问题的判断方法.docx》检查。\n3 请联系技术工程师协助解决。",
        "en":"Failed to connect to engines whose numbers are: %s. You can perform the following operations:\n1. Recover the connection between the tool and engine whose engine number are:%s, and perform a check again. \n2. Refer to the Identification Method About Data Loss Caused by Cache Mirroring Disabled for LUNs of Storage Devices.docx in CIT-P-S-201713 warning to perform the check.\n3. Contact technical support engineers.",
    },
"heart.beat.to.node.failed":
    {
        "zh":u"\n通过心跳连接到控制器节点：%s 失败。",
        "en":"\nFailed to connect to controller node %s based on the heartbeat."
    },
"faied.to.transform.lun.to.volume":
    {
        "zh":u"\n存储设备上以下LUN的ID转化为卷ID失败，请联系技术支持工程师协助处理，LUN ID为：\n%s",
        "en":"\nThe IDs of the following LUNs on the storage device failed to be converted into volume IDs. Contact technical support. The LUN IDs are \n%s"
    },
"faied.to.transform.snapshot.to.volume":
    {
        "zh":u"\n存储设备上以下快照的ID转化为卷ID失败，请联系技术支持工程师协助处理， 快照ID为：\n%s",
        "en":"\nThe IDs of the following snapshots on the storage device failed to be converted into volume IDs. Contact technical support. The snapshot IDs are \n%s"
    },
"faied.to.transform.volume.to.LunOrSnapshot":
    {
        "zh":u"\n存储设备上以下卷ID转换为快照的ID或者LUN的ID失败，请联系技术支持工程师协助处理， 卷ID为：\n%s",
        "en":"\nThe IDs of the following volumes on the storage device failed to be converted into snapshot IDs or LUN IDs. Contact technical support. The volume IDs are \n%s"
    },
"cant.find.lun.mirrorinfo":
    {
        "zh":u"\n存储设备上以下LUN的镜像信息获取失败，请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检；否则，请联系技术支持工程师协助处理。 LUN ID为：\n%s",
        "en":"\nMirror information about the LUNs on the storage device failed to be obtained. Check whether a LUN migration or volume mirroring operation is going on during the assessment. If such an operation exists, wait for the operation to complete and retry the assessment. If no such operation exists, contact technical support. The LUN IDs are \n%s"
    },
"cant.find.snapshot.mirrorinfo":
    {
        "zh":u"\n存储设备上以下快照的镜像信息获取失败，请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检；否则，请联系技术支持工程师协助处理。 快照ID为：\n%s",
        "en":"\nMirror information about the LUNs on the storage device failed to be obtained. Check whether a LUN migration or volume mirroring operation is going on during the assessment. If such an operation exists, wait for the operation to complete and retry the assessment. If no such operation exists, contact technical support. The snapshot IDs are \n%s"
    },
"dedupCompress.lun.write.mirror.status.not.check.as.license.file.missing":
    {"zh":u"\nLicense文件不存在，查询开启过重删压缩开关的LUN的信息失败。若存储系统存在开启过重删压缩开关的LUN，则所有开启过重删压缩开关的LUN的cache镜像功能未检查，请导入License后重新检查；若存储系统不存在开启过重删压缩开关的LUN，请忽略此提示信息。",
     "en":"\nFailed to query information about LUNs whose deduplication and compression are enabled because no license file exists. If there are LUNs whose deduplication and compression functions are enabled in the system, the cache mirroring function of all LUNs with deduplication and compression enabled are not checked. Import a license and check again. If there is no LUNs whose deduplication and compression are enabled in the system, skip this prompt message."
    },
"dedupCompress.lun.not.mirror":
    {"zh":u"\n请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检。\n存储设备上以下开启过重删压缩开关的LUN的Cache镜像功能关闭， 开启过重删压缩开关的LUN的ID为：\n%s",
     "en":"\nCheck whether a LUN migration or volume mirroring operation is going on during the inspection. If such an operation exists, wait for the operation to complete and retry the inspection.\nThe cache mirroring functions of the following LUNs whose deduplication and compression are enabled on the storage device are disabled. The IDs of LUNs whose deduplication and compression functions are enabled are:\n%s"
    },
"dedupCompress.work.in.single.ctrl.mode":
    {"zh":u"\n请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检。\n存储设备上以下开启过重删压缩开关的LUN工作在单控模式，存在将开启过重删压缩开关的LUN的Cache镜像功能由关闭更改为开启的操作，开启过重删压缩开关的LUN的ID为：\n%s",
     "en":"\nCheck whether a LUN migration or volume mirroring operation is going on during the inspection. If such an operation exists, wait for the operation to complete and retry the inspection.\nThe following LUNs whose deduplication and compression are enabled on the storage device work in single-controller mode, and the cache mirroring states of the LUNs whose deduplication and compression are enabled are changed from disabled to enabled. The IDs of LUNs whose deduplication and compression functions are enabled are:\n%s"
    },
"dedupCompress.lun.mirror.status.unknown":
    {"zh":u"\n存储设备上以下开启过重删压缩开关的LUN的Cache镜像状态查询失败，请联系技术支持工程师协助处理， 开启过重删压缩开关的LUN的ID为：\n%s",
     "en":"\n\nFailed to query the cache mirroring functions of the following LUNs whose deduplication and compression are enabled on the storage device. Contact technical support engineers.  The IDs of LUNs whose deduplication and compression functions are enabled are:\n%s"
    },
"faied.to.transform.dedupCompressLun.to.volume":
    {"zh":u"\n存储设备上以下开启过重删压缩开关的LUN的ID转化为卷ID失败，请联系技术支持工程师协助处理， 开启过重删压缩开关的LUN的ID为：\n%s",
     "en":"\nThe IDs of the following LUNs whose deduplication and compression are enabled on the storage device failed to be converted into volume IDs. Contact technical support. The The IDs of LUNs whose deduplication and compression functions are enabled are: \n%s"
    },
"cant.find.dedupCompressLun.mirrorinfo":
    {"zh":u"\n存储设备上以下开启过重删压缩开关的LUN的镜像信息获取失败，请确认巡检过程中系统是否正在进行LUN迁移或卷镜像操作。如果正在进行上述操作，则等待操作执行完成后再次进行巡检；否则，请联系技术支持工程师协助处理。 开启过重删压缩开关的LUN的ID为：\n%s",
     "en":"\nMirror information about the LUNs whose deduplication and compression are enabled on the storage device failed to be obtained. Check whether a LUN migration or volume mirroring operation is going on during the inspection. If such an operation exists, wait for the operation to complete and retry the inspection. If no such operation exists, contact technical support. The The IDs of LUNs whose deduplication and compression functions are enabled are: \n%s"
    },
"check.mirror.largeMaxCheckNum.notpass":
    {
        "zh":u"\n系统中前1000个LUN或快照已经存在LUN或快照的Cache镜像状态错误风险（%s），系统中其他LUN/快照也可能存在风险，请联系技术工程师进行处理。",
        "en":"\nThe cache mirror states are incorrect for the first 1000 LUNs or snapshots in the system (%s). Other LUNs or snapshots in the system may also have risks that the states are incorrect. Contact technical support engineers."
    },
"check.mirror.largeMaxCheckNum.warning":
    {
        "zh":u"\n系统中可能存在LUN或快照的Cache镜像状态错误的风险，影响系统升级，请参考修复建议“系统中LUN和快照总数超过1000的场景”中检查结果为警告的建议进行处理。",
        "en":"\nThe cache mirror states of LUNs may be incorrect in the system, which affects the system upgrade. Refer to 'Scenario: The total number of LUNs and snapshots exceeds 1000' in which the check result is Warning."
    },
"lun.id.list":
    {
        "zh":u"\nLUN的ID为：%s",
        "en":"\nThe LUN IDs are %s"
    },
"snapshot.id.list":
    {
        "zh":u"\n快照的ID为：%s",
        "en":"\nThe snapshot IDs are %s"
    },
"decompresssublun.id.list":
    {
        "zh":u"\n开启过重删压缩开关的LUN的ID为：%s",
        "en":"\nThe IDs of LUNs whose deduplication and compression functions are enabled are %s"
    },
"exist.lun.not.mirror":
    {
        "zh":u"\n系统中存在LUN（ID：%s）的Cache镜像状态错误的风险，影响系统升级，请使用巡检工具做进一步检查并修复问题。",
        "en":"\nThe cache mirror state of LUN (ID: %s) may be incorrect in the system, which affects the system upgrade. Use the inspection tool to perform a further check and rectify the fault."
    },
"exist.snapshot.not.mirror":
    {
        "zh":u"\n系统中存在快照（ID：%s）的Cache镜像状态错误的风险，影响系统升级，请使用巡检工具做进一步检查并修复问题。",
        "en":"\nThe cache mirror state of snapshot (ID: %s) may be incorrect in the system, which affects the system upgrade. Use the inspection tool to perform a further check and rectify the fault."
    },
"exist.dedupCompressLun.not.mirror":
    {
        "zh":u"\n系统中存在开启过重删压缩开关的LUN（ID：%s）的Cache镜像状态错误的风险，影响系统升级，请使用巡检工具做进一步检查并修复问题。",
        "en":"\nThe cache mirror state of the LUN whose deduplication and compression feature is enabled (ID: %s) may be incorrect in the system, which affects the system upgrade. Use the inspection tool to perform a further check and rectify the fault."
    },

"have.same.path":
    {
        "zh": u"NFS共享名称存在相同的路径，Share ID为：\n%s",
        "en": "NFS share's name have the same path. Share ID is:\n%s"
    },
"dns.server.disposelist.overstep":
    {
        "zh":u"\nDNS Server探测配置列表配置了%s个地址。",
        "en":"\n%s addresses are configured in the configuration list of DNS servers to be detected."
    },
"cannot.get.dns.server.disposelist":
    {
        "zh":u"\n获取DNS Server探测配置列表信息失败",
        "en":"\nFailed to obtain information about the configuration list of DNS servers to be detected.",
    },
"KVDB.check.fail":
    {
        "zh": u"\nKVDB实例资源不够，存在升级失败的风险。",
        "en": "\nKVDB instance resource not enough ,the upgrade may fail."
    },
"log.check.collect.success":
    {
        'zh': u'日志收集成功。\n',
        'en': 'Log collection succeeded\n'
    },
"log.check.collect.fail":
    {
         'zh': u'\n日志收集未完成，不支持自动评估。\n请使用信息收集工具收集日志，再根据当前检查项的检查规则匹配日志进行人工分析。',
         'en': '\nLog collection is not complete. Automatic evaluation is not supported. \nCollect logs using the information collection tool, and then perform manual analysis on logs that are matched based on the check rules of the current check items.'
     },
"log.check.analyze.fail":
    {
         'zh': u'\n日志分析未完成，不支持自动评估。\n请使用信息收集工具收集日志，再根据当前检查项的检查规则匹配日志进行人工分析。',
         'en': '\nLog analyze is not complete. Automatic evaluation is not supported. \nCollect logs using the information collection tool, and then perform manual analysis on logs that are matched based on the check rules of the current check items.'
     },
"log.check.collect.fail.ssh.forward":
    {
       'zh': u'\n当前工具版本不支持使用SSH跳转方式收集日志，请升级工具箱版本至最新版本重新评估或使用信息收集工具收集日志再根据当前检查项的检查规则匹配日志进行人工分析评估。',
       'en': '\nThe tool of the current version does not support log collection in SSH forwarding mode. Upgrade Toolkit to the latest version and perform the evaluation again, or use the information collection tool to collect logs and then match logs based on the check rules of the current check items for manual analysis and evaluation.'
    },
"log.check.collect.fail.socks5":
    {
       'zh': u'\n当前工具版本不支持使用Socks5代理方式收集日志，请升级工具箱版本至最新版本重新评估或使用信息收集工具收集日志再根据当前检查项的检查规则匹配日志进行人工分析评估。',
       'en': '\nThe tool of the current version does not support log collection using the Socks5 proxy. Upgrade Toolkit to the latest version and perform the evaluation again, or use the information collection tool to collect logs and then match logs based on the check rules of the current check items for manual analysis and evaluation.'
     },
"log.check.collect.cliRetTitle":
    {
       'zh': u'在日志中根据规则匹配到的信息如下：\n',
       'en': 'Rules for matching the following information in logs:\n'
    },
"log.check.collect.successCliRetTitle":
    {
       'zh': u'在日志中根据规则未匹配到信息。\n',
       'en': 'No information is found in logs based on the rules.\n'
    },
"get.ip.fail":
    {
        "zh": u"\n无法获取%s的IP信息。",
        "en": "\nCannot get information about %s."
    },
"ping.ip.fail":
    {
        "zh": u"\n无法访问的%s的IP有:%s。",
        "en": "\nThe following IP addresses of %s cannot be accessed: %s."
    },
"checkProtocol.cannotUpgrade":
    {
        "zh": u"\n系统使用了（%s）NAS服务，不允许在线升级。",
        "en": "The system uses the (%s) NAS service and the online upgrade is not allowed."
    },
"checkProtocol.exsitRisk":
    {
        "zh": u"\n系统使用了（%s）NAS服务，因为NAS协议自身原因，升级存在一定风险。请参照修复建议处理。",
        "en": "The system uses the (%s) NAS service. Due to the NAS protocol, the upgrade may be risky. Rectify the fault according to the rectification suggestion."
    },
"excute.cmd.error":
    {
        "zh": u"\n执行命令出错，请重试，重试仍不通过，请联系技术工程师处理。",
        "en": "An error occurs during command execution. Please try again. If the error persists, contact Huawei technical support engineers."
    },
"hcDlmCheckBefore.notpass.hotpatchSan":
    {
        "zh": u"\n存储配置了SAN双活，请参照最新的升级指导书进行升级操作，并且升级完成后请安装%s或以后版本的补丁。如果未找到补丁，请联系技术工程师处理。",
        "en": "\nSAN HyperMetro is configured on the storage device. Perform the upgrade by referring to the latest upgrade guide and then install the patch of %s or a later version after the upgrade. If you did not find the required patch, contact Huawei technical support engineers."
    },

"hcDlmCheckBefore.notpass.hotpatch":
    {
        "zh": u"\n升级完成后请安装%s或以后版本的补丁。如果未找到补丁，请联系技术工程师处理。",
        "en": "\nAfter the system is upgraded, install the patch of %s or a later version. If you did not find the required patch, contact Huawei technical support engineers."
    },
"portFCoE.notpass":
    {
        "zh": u"\n运行状态为已连接的FCoE端口有:%s",
        "en": "\nFCoE ports whose Running Status are Link Up involve: %s"
    },
"check.result.abnormal":
    {
        "zh":u"\n控制器[%s]:检查结果异常",
        "en":"\nExecution abnormal of controller [%s]",
    },
    "replicationPair.not.split":
        {
            "zh": u"\n以下阵列间远程复制的运行状态不为分裂,ID为：%s",
            "en": "\nThe running status of the following remote replication between storage arrays is not splited. The IDs are:%s",
        },
    "hyperMetroPair.not.split":
        {
            "zh": u"\n以下双活的运行状态不为分裂，ID为：%s",
            "en": "\nThe following HyperMetro running status is not splited. The IDs are:%s",
        },
    "hyperVaultJob.not.completeOrCancel":
        {
            "zh": u"\n以下一体化备份作业的运行状态不是完成或取消，ID为：%s",
            "en": "\nThe running status of the following HyperVault jobs is not completed or canceled. The IDs are:%s",
        },
    "inter.array.lunCopy.running":
        {
            "zh": u"\n以下阵列间LUN拷贝状态为排队或拷贝中，ID为：%s",
            "en": "\nThe status of LUN copy between the following arrays is in the queuing or copying state. The IDs are:%s",
        },

    "check.hpux.gethosterr":
        {
            "zh":u"\n无法获取主机信息",
            "en":"\nFailed to obtain the information of hosts",
        },
    "check.hpux.gethostlunerr":
        {
            "zh":u"\n无法获取主机映射的LUN信息（主机ID：%s）",
            "en":"\nFailed to obtain the lun information for the host(ID:%s)",
        },
    "check.hpux.gethostiniterr":
        {
            "zh":u"\n无法获取主机映射的启动器信息（主机ID：%s）",
            "en":"\nFailed to obtain the initiators information for the host(ID:%s)",
        },
    "check.hpux.have.lun0":
        {
            "zh":u"\n检查到以下ID的主机存在风险：%s",
            "en":"\nThere are risks with the following hosts(ID):%s",
        },
}
