# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.common.config import DISK_BLACK_ITEMS

def execute(context):
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    cliRet = ""
    DiskLocationList = []#检测到不通过硬盘的位置信息
    try:
        cmd = "show disk general"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, False, lang)
        cliRet = checkRet[1]
        printCliRet(cliRet, 20, logger)
        
        if checkRet[0] != True:
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        diskBlackItems = DISK_BLACK_ITEMS
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        #判断每一款硬盘是否不配套，不配套的记录其位置信息
        for cliRetLine in cliRetLinesList:
            item = cliRetLine.get("Item")
            if item in diskBlackItems:
                DiskLocationList.append(cliRetLine.get("ID"))
        
        logger.logInfo("DiskLocationList:[%s]" % unicode(DiskLocationList))
        if len(DiskLocationList) > 0:
            locationStr = ", ".join(DiskLocationList)
            return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "disks.not.match", locationStr))
        
        return common.getUpgEvaluationRs(True, cliRet,"")
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))  
    
    
def printCliRet(cliRet, num, logger):
    '''
    @summary: 以num作为规格划分打印日志
    '''
    lines = cliRet.splitlines()
    length = len(lines)
    for i in range(1, length):
        mul = i%num
        if mul == 0:
            logger.logInfo("\n%s" % "\n".join(lines[i-num:i]))
            continue
        if i == length-1:
            logger.logInfo("\n%s" % "\n".join(lines[i-mul:length]))
    return
