# -*- coding: UTF-8 -*-
from frame.common import common
from frame.cli import cliUtil
from frame.context import contextUtil

CUR_VER_LIST = ["V300R002C10","V300R003C00","V300R003C10"]
TARGET_VER_LIST = ["V300R003C20","V300R003C20SPC100","V300R003C20SPC200","V300R006C00","V300R006C00SPC100"]
RUN_MODE = "FCoE/iSCSI"

def execute(context):
    '''
    SmartIO 卡运行模式检查
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRetAll = ""
    errMsg = ""

    try:
        curentVersion = contextUtil.getCurVersion(context)
        targetVersion = contextUtil.getTargetVersion(context)
        LOGGER.logInfo("curentVersion: %s ,targetVersion: %s" % (curentVersion,targetVersion))
        if curentVersion not in CUR_VER_LIST or targetVersion not in TARGET_VER_LIST:
            return common.getUpgEvaluationRs(True, cliRetAll, errMsg)
        
        #查询所有接口看信息
        cmd = "show interface_module"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetAll += "\n%s"%checkRet[1]
        
        if checkRet[0] != True: 
            errMsg += checkRet[2]
            return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        
        #判断所有接口卡的Run Mode
        cmd = "show interface_module interface_module_id=%s"
        for cliRetLines in cliRetLinesList:
            intfId = cliRetLines.get("ID")
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd%intfId, True, LANG)
            cliRetAll += "\n%s"%checkRet[1]
        
            (checkFlag, errMsg) = checkRunMode(checkRet, LOGGER, LANG)
            if checkFlag != True:
                return common.getUpgEvaluationRs(checkFlag, cliRetAll, errMsg)
        
        #获取所有控制器ID   
        checkRet = cliUtil.getControllerIdList(cli, LANG)
        if checkRet[0] != True:
            errMsg += checkRet[2]
            return common.getUpgEvaluationRs(checkRet[0], cliRetAll, errMsg)
        
        ctrlIdList = checkRet[1]
        
        #判断所有控制器的Run Mode信息
        cmd = "show controller general controller=%s"
        for ctrlId in ctrlIdList:
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd%ctrlId, True, LANG)
            cliRetAll += "\n%s"%checkRet[1]
            
            (checkFlag, errMsg) = checkRunMode(checkRet, LOGGER, LANG)
            if checkFlag != True:
                return common.getUpgEvaluationRs(checkFlag, cliRetAll, errMsg)
            
        return common.getUpgEvaluationRs(True, cliRetAll, errMsg)
        
    except Exception, exception: 
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(False, cliRetAll, common.getMsg(LANG, 'query.result.abnormal'))

def checkRunMode(checkRet,LOGGER,LANG):
    if checkRet[0] != True: 
        errMsg = checkRet[2]
        return (checkRet[0], errMsg)
            
    cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
    
    if len(cliRetLinesList)==0:
        LOGGER.logInfo("Qeury result info failed.")
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        return (False, errMsg)
    
    runMode = cliRetLinesList[0].get("Run Mode")
    LOGGER.logInfo("The run mode is: %s ." %runMode)
    if RUN_MODE == runMode:
        errMsg = common.getMsg(LANG, "intf.runMode.notpass")
        return (False, errMsg)
    return (True, "")
