# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    @summary: cache分区Fault页面检查
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        checkRet = cliUtil.getControllerIdList(cli, lang)
        if checkRet[0] != True:
            return common.getUpgEvaluationRs(checkRet[0], checkRet[1], checkRet[2])
        
        controlList = checkRet[1]
        for controlId in controlList:
            cmd = "show cache blocked_page controller=%s" % controlId
            checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang, preExec = False)
        
            cliRet += checkRet[1] + "\n"
            if checkRet[0] != True:
                errMsg += "\n[%s]:%s" % (controlId, checkRet[2].replace("\n", " "))
                flag = common.getCheckResult([checkRet[0],flag])
                continue
                  
            cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
            faultPageNum = cliRetLinesList[0].get("Blocked Counter")
            if int(faultPageNum) > 0:
                flag = False
                errMsg += common.getMsg(lang, "control.exist.cahce.fault", controlId)
                logger.logNoPass("Controller [%s]:Block pages are displayed." % controlId)

        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
        
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))   
    

    
