# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

checkCurrentVersionLst = ['V300R002C00', 'V300R002C00SPC100', 'V300R002C10', 'V300R002C10SPC100', 'V300R002C10SPC200', 'V300R003C00', 'V300R003C00SPC100']
checkTargetVersionLst = ['V300R003C10', 'V300R003C10SPC100']


def execute(context):
    """
    :param context:  NFS共享名称检查:查看回显中“Local Path”字段的信息，如果第一级目录（区分大小写）相同，其子目录在不区分字母大小写的情况下相同（如：/wq/Qa和/wq/qa则为不通过）则检查不通过，否则检查通过。
    :return:
    """
    checkRet = ""
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    _, currentVersion, _ = common.getDevVersion(cli, lang, logger)
    targetVersion = contextUtil.getTargetVersion(context)
    logger.logInfo("currentVersion is [%s],upgradeVersion is [%s]." % (currentVersion, targetVersion))
    if currentVersion not in checkCurrentVersionLst or targetVersion not in checkTargetVersionLst:
        return common.getUpgEvaluationRs(True, checkRet, "")
    try:
        cmd = "show share nfs"
        logger.logExecCmd(cmd)
        ok, checkRet, _ = cliUtil.excuteCmdInCliMode(cli, cmd, False, lang)
        if ok != True:
            logger.logSysAbnormal()
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, checkRet, common.getMsg(lang, "query.result.abnormal"))

        # 不存在回显，即未配置共享
        if cliUtil.queryResultWithNoRecord(checkRet):
            return common.getUpgEvaluationRs(True, checkRet, "")

        cliRetDictList = cliUtil.getHorizontalNostandardCliRet(checkRet)
        if len(cliRetDictList) == 0:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, checkRet, "")

        allDict = {}
        allShareID = []
        for oneRetDict in cliRetDictList:
            localPath = oneRetDict.get("Local Path")
            firstPath = localPath.split('/')[1]
            secondePath = localPath[localPath.find('/', 1):].lower()
            shareID = oneRetDict.get("Share ID")
            # 第一级目录作为键值

            if firstPath not in allDict:
                allDict[firstPath] = []
            if secondePath in allDict[firstPath]:
                # 在相同的第一级目录下，是否存在相同的子目录
                allShareID.append(shareID)
                continue
            allDict[firstPath].append(secondePath)

        if allShareID:
            return common.getUpgEvaluationRs(False, checkRet, common.getMsg(lang, "have.same.path", '\n'.join(allShareID)))

        return common.getUpgEvaluationRs(True, checkRet, "")
    except Exception, e:
        logger.logException(e)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, checkRet, common.getMsg(lang, "query.result.abnormal"))