# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil

def execute(context):
    '''
    CIFS共享配置检查。
    '''
    LANG = contextUtil.getLang(context)
    LOGGER = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    flag = True
    cliRet = ""
    errMsg = ""
    cifsVersion = ["V300R003C10SPC100", "V300R003C20", 
                   "V300R003C20SPC100", "V300R005C00SPC300", 
                   ]
    try:
#         CIFS共享配置检查版本范围
        curVersion = contextUtil.getCurVersion(context)
        targetVersion = contextUtil.getTargetVersion(context)
        if curVersion not in cifsVersion and targetVersion not in cifsVersion:
            LOGGER.logInfo("the current version or the target version is not records about service cifs.")
            return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
        cmd = "show service cifs"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]

        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)

        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            errMsg = checkRet[2]
            return common.getUpgEvaluationRs(checkRet[0], cliRet, errMsg)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            LOGGER.logInfo("there is not records about service cifs.")
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            LOGGER.logNoPass("query result abnormal about service cifs.")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        for retDict in cliRetLinesList:
            runningStatus = retDict.get("Running Status")
            if runningStatus == common.STATUS_STOP:
                LOGGER.logNoPass("The Running Status of service cifs is :%s"  % (runningStatus))
                return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
        cmd = "show share cifs"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet +=  "\n%s" %checkRet[1]
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            errMsg = checkRet[2]
            return common.getUpgEvaluationRs(checkRet[0], cliRet, errMsg)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            LOGGER.logInfo("there is not records about share cifs.")
            return common.getUpgEvaluationRs(True, cliRet, checkRet[2])
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            LOGGER.logNoPass("query result abnormal about share cifs.")   
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, errMsg) 
         
        cmd = "show share cifs share_id=%s"
        for retDict in cliRetLinesList:
            shareID = retDict.get("Share ID")
            
            LOGGER.logExecCmd(cmd%shareID)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd%shareID, True, LANG)
            cliRet += "\n%s" %checkRet[1]
            if checkRet[0] != True: 
                LOGGER.logSysAbnormal()
                errMsg = checkRet[2]
                return common.getUpgEvaluationRs(checkRet[0], cliRet, errMsg)
            
            cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
            if len(cliRetLinesList) == 0:   
                errMsg = common.getMsg(LANG, "query.result.abnormal")
                return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, errMsg) 
             
            for retDict in cliRetLinesList:
                Continue_Available_Enabled = retDict.get("Continue Available Enabled")
                Smb2_CA_Enabled = retDict.get("Smb2 CA Enabled")
                if "Enable" == Continue_Available_Enabled or "Enable" == Smb2_CA_Enabled:
                    errMsg = common.getMsg(LANG, "cifs.share.conf.notpass")
                    LOGGER.logNoPass("The value of Continue Available Enabled or SMB2 CA Enabled field is [%s,%s]:" %(Continue_Available_Enabled,Smb2_CA_Enabled))
                    return common.getUpgEvaluationRs(False, cliRet, errMsg)
        
        LOGGER.logPass()
        return common.getUpgEvaluationRs(True, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
