# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.common import config
from frame.context import contextUtil
import traceback

targerVersionList = ["V300R006C10SPC100","V500R007C00SPC100"]
noSupportDeviceTypeList = ["2200 V3", "2600 V3 for Video", "2800 V3", "2800 V5"]


def execute(context):
    '''
                     升级前评估时，对双活业务配置检查是否存在风险检查。

步骤1 以admin用户登录设备
步骤2 升级工具确认升级目标版本是否为V300R006C10SPC100或者V500R007C00SPC100版本。
步骤3 执行命令show hyper_metro_pair general |filterRow column=Type predict=equal_to value=LUN，查看当前阵列配置的所有的SAN双活Pair。
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cli = contextUtil.getSSH(context)
    cliRet = ""
    errMsg = ""
    
    try:
        tagerVersion = contextUtil.getTargetVersion(context)
        deviceType = contextUtil.getDevType(context)
        logger.logInfo("tagerVersion is :%s,deviceType is :%s." % (tagerVersion,deviceType))
        if deviceType in noSupportDeviceTypeList or tagerVersion not in targerVersionList:
            #不在检查范围内返回不涉及
            logger.logInfo("The device no need Check.")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, "")

        errMsg = "hcDlmCheckBefore.notpass.hotpatch"

        cmd = "show hyper_metro_pair general |filterRow column=Type predict=equal_to value=LUN"
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        #出现^结果为不涉及
        if not cliUtil.hasCliExecPrivilege(cliRet):
            logger.logInfo("cliRet have ^ or not have privilege.")
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet,"")
        #下发命令失败，未检查
        if not checkRet[0]:
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
        if not cliUtil.queryResultWithNoRecord(cliRet):
            logger.logInfo("The device have San.")
            errMsg += "San"
            
        return common.getUpgEvaluationRs(cliUtil.RESULT_WARNING, cliRet,
                                         common.getMsg(lang, errMsg, config.HOT_PATCH_DICT.get(tagerVersion, "")))

    except:
        logger.logInfo("exception=[%s]" % str(traceback.format_exc()))
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
