# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil

def execute(context):
    '''
    @summary: ibc_os_hs账户密码是否为默认检查 
    '''
    
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    
    try:
        flag = True
        errMsg = ""
        
        targetVer = contextUtil.getTargetVersion(context)
        
        if targetVer <= "V300R006C00":
            logger.logInfo("check ibc password not support this target version:%s"%unicode(targetVer))
            return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        tlvCon = contextUtil.getTlvObj(context)
        
        res = tlvUtil.isIBCPasswordChanged(tlvCon)
        logger.logInfo("check ibc password result:%s"%unicode(res))
        if 0!=res:
            errMsg += common.getMsg(lang, "ibc.passwd.changed")
            return common.getUpgEvaluationRs(False, cliRet, errMsg)
        
        return common.getUpgEvaluationRs(True, cliRet, errMsg)
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))


