# -*- coding: UTF-8 -*-
from frame.cli import cliUtil
from frame.common import common
from frame.context import contextUtil
from frame.tlv import tlvUtil
from frame.tlv import tlvData
import  com.huawei.ism.tool.protocol.tlv.exception.TLVException as TLVException
OM_CMD_NO_REGISTERED_CODE = [1077949002, 1073846111, 1073846112]#命令字不存在的异常错误码
VMM_CMD_NO_PASSED_CODE = [1073846126]#虚拟机服务正在启动的异常错误码

def execute(context):
    '''
    @summary: 所有虚拟机是否关闭检测
    '''
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    cliRet = ""
    try:
        flag = True
        errMsg = ""

        tlv = contextUtil.getTlvObj(context)
        checkItem = "CHECK_SOFTWARE_VMMACHINE_SHUTDWON"
        logger.logExecCmd(checkItem)
        #根据检查项获取配置字典值
        itemDict = tlvData.UPD_CHECK_RESULT[checkItem]
        
        #获取cli回显，不管回显是啥都将其返回到原始信息
        cli = contextUtil.getSSH(context)
        cmd = "show virtual_machine general"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        
        try:
            recs = tlvUtil.getAllKindsTLVRecords(tlv, checkItem , logger)
        except TLVException, jexcp:
            logger.logInfo("TLV exception msg=%s" % jexcp.getErrorId())
            if jexcp.getErrorId() in OM_CMD_NO_REGISTERED_CODE:
                return common.getUpgEvaluationRs(flag, cliRet, errMsg)
            if jexcp.getErrorId() in VMM_CMD_NO_PASSED_CODE:
                errMsg = common.getMsg(lang, "virtual.machine.service.starting")
                return common.getUpgEvaluationRs(False, cliRet, errMsg)
            raise Exception (jexcp.toString())
        except Exception, msg:
            logger.logInfo("exception msg=%s" % msg)
            #如果命令字不存在，检查直接通过。
            if msg[0] in OM_CMD_NO_REGISTERED_CODE:
                return common.getUpgEvaluationRs(flag, cliRet, errMsg)
            if msg[0] in VMM_CMD_NO_PASSED_CODE:
                errMsg = common.getMsg(lang, "virtual.machine.service.starting")
                return common.getUpgEvaluationRs(False, cliRet, errMsg)
            raise Exception (msg)
        
        logger.logInfo("records=%s" % unicode(recs))

        for record in recs:
            nodeId = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["CONTROLLER_ID"])
            result = tlvUtil.getRecordValue(record, tlvData.CMO_UPD_EXECUTE_DEFINE["CONTROLLER_NUM"])
            #根据模块返回值获取对应的字典值,如果失败返回None
            itemVal = itemDict.get(result, None)
            if itemVal is None:
                errMsg += common.getMsg(lang, "check.result.abnormal", nodeId)
                flag = False
                continue
            #只有status为False时才获取错误信息
            status = itemVal.get("status", None)
            if status is True:
                continue
            flag = False
            errMsg += common.getMsg(lang, itemVal["msg"], nodeId)
        return common.getUpgEvaluationRs(flag, cliRet, errMsg)
    
    except Exception, exception:
        logger.logException(exception)
        return common.getUpgEvaluationRs(False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    