# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus
from frameone.base.constants import  CheckResult
from business.common.util import *
import re
from frameone.util import baseUtil
#检查项关键字
totalLogNum = "Total log num:"
remainFreeLogNum = "Remain free log num:"
cliCmd = "sys showcfglog"

cliRet = []
def execute(dataDict):
    dataDict['checkType'] = "PRECHECK"
    #执行升级前检查
    return updateUi(dataDict)
    

"""
    查询升级检查项，并更新界面
"""
def updateUi(dataDict):
    dev = dataDict.get("dev")
    logger = dataDict.get("logger")
    ssh  = dataDict.get("ssh")
    lang = dataDict.get("lang")
    developerPwd = dev.getDeveloperPwd()
    
    #检查项状态 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
    itemState = 1
    errorKey = ""
    
    #当前检查项告警ID
    logger.info("[SysConfigurationLogCheck] change model to debug begin!")
    if not developerPwd:#判断是否输入密码
        #密码为空
        itemState = 4
        errorKey = "SysConfigurationLogCheck.notDebugPwd"
        logger.info("[SysConfigurationLogCheck] not enter developer password!")
    else:
        #检测到有输入密码
        if not changeCli2Debug(developerPwd, ssh):
            #切换develoer模式失败
            itemState = 4
            errorKey = "SysConfigurationLogCheck.changeModelFailed"
            logger.info("[SysConfigurationLogCheck] change model to debug succeed!")
        #模式切换成功
        else:
            cmdRet = execCmdRetry(ssh, cliCmd)
            cliRet.append(cmdRet)
            retStrLines = cmdRet.splitlines()
            #数据零时保存对象        
            totalLogNumVer = ""
            remainFreeLogNumVer = ""
            for line in retStrLines:
                #搜索到Total log num:  保存起来
                if re.search(totalLogNum, line, re.IGNORECASE):
                    totalLogNumVer = line.split(":")[-1].strip()
                    continue
                #搜索到Remain free log num:  保存起来
                if re.search(remainFreeLogNum, line, re.IGNORECASE):
                    remainFreeLogNumVer = line.split(":")[-1].strip()
                    continue
            #totalLogNumVer or totalLogNumVer 不能为空且必须相等
            if not totalLogNumVer or not remainFreeLogNumVer or totalLogNumVer != remainFreeLogNumVer:
                itemState = 4
                errorKey = "SysConfigurationLogCheck.notpass"
                logger.info("[SysConfigurationLogCheck]check is notpass! totalLogNumVer:" + str(totalLogNumVer) +"   remainFreeLogNumVer:" + str(remainFreeLogNumVer))
            else:
                itemState = 3
                errorKey = "SysConfigurationLogCheck.pass"
                logger.info("[SysConfigurationLogCheck]check pass!")
            
    #切换模式到CLI
    changeAnyModel2Cli(ssh)
    #刷新结果
    suggession = baseUtil.getMsg(lang, errorKey)
    
    itemMsg = {
        ##检查项名称，类型String
        ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
        "status":itemState % 3,
        ##修复建议
        "suggession":suggession
    }
    
    return CheckResult(itemMsg["status"], cliRet, itemMsg["suggession"]).toScriptResult()