# -*- coding: UTF-8 -*-
"""
@version: Toolkit V200R006C00
@time: 2020/02/17
@file: check_cli_check_failing_to_obtain_upgrade_path.py
@function:
@modify:
"""
from business.common import common
from frameone.base.constants import CheckStatus
from frameone.util import contextUtil
from cbb.frame.cli import cliUtil

BUG_DEV_TYPE = {'18500 V3', '18800 V3', '18500F V3', '18800F V3'}
BUG_DEV_VERSION = {'V300R006C00SPC100', 'V300R006C01', 'V300R006C10'}
MIN_CHECK_CONTROLLER_NUM = 8


def execute(context):
    return FailingToObtainUpgradePathCheck(context).check()


class FailingToObtainUpgradePathCheck:
    """
    升级路径设置失败检查
    """

    def __init__(self, context):
        self.logger = common.getLogger(contextUtil.getLogger(context),
                                       __file__)
        self.cli = contextUtil.getSSH(context)
        self.lang = contextUtil.getLang(context)
        self.cli_rets = []
        self.err_msgs = []
        self.context = context

    def _get_cli_ret(self):
        """
        返回原始信息
        :return: cliRet
        """
        if self.cli_rets:
            return "\n".join(self.cli_rets)
        else:
            return "No information"

    def _get_err_msg(self):
        """
        返回错误信息
        :return: cliRet
        """
        return "\n".join(self.err_msgs)

    def check(self):
        """
        检查控制器数量，版本信息
        :return:
        """
        try:
            # 获取版本回显
            dev_flag, dev_version, dev_cli_ret = \
                common.getDevVersion(self.cli, self.lang, self.logger)
            self.cli_rets.append(dev_cli_ret)
            # 获取型号
            dev_type = contextUtil.getDevType(self.context)
            # 获取版本
            current_version = contextUtil.getCurVersion(self.context)
            # 检查型号及版本
            if dev_type.upper() not in BUG_DEV_TYPE \
                    or current_version.upper() not in BUG_DEV_VERSION:
                return CheckStatus.PASS, self._get_cli_ret(), self. \
                    _get_err_msg()
            # 获取控制器
            controller_names = []
            check_controller_cmd = 'show controller general |filterColumn' \
                                   ' include columnList=Controller'
            check_controller_flag, cli_ret, err_msg = \
                cliUtil.excuteCmdInCliMode(
                    self.cli, check_controller_cmd, True, self.lang)
            self.cli_rets.append(cli_ret)
            if check_controller_flag is not True:
                self.err_msgs.append(err_msg)
                return CheckStatus.NOCHECK, self._get_cli_ret(), self. \
                    _get_err_msg()
            ctrl_name_list = cliUtil.getVerticalCliRet(cli_ret)
            for line in ctrl_name_list:
                ctrl_name = line.get('Controller', '')
                if bool(ctrl_name) and ctrl_name != '--':
                    controller_names.append(ctrl_name)
            controller_num = len(controller_names)
            # 检查控制器
            if controller_num <= MIN_CHECK_CONTROLLER_NUM:
                return CheckStatus.PASS, self._get_cli_ret(), self. \
                    _get_err_msg()
            version_error = common. \
                getMsg(self.lang,
                       'check.failing.to.obtain.'
                       'upgradepath.error.version',
                       (controller_num, dev_version))
            self.err_msgs.append(version_error)
            return CheckStatus.NOTPASS, self._get_cli_ret(), self. \
                _get_err_msg()
        except Exception as exception:
            self.logger.logException(exception)
            return CheckStatus.NOCHECK, self._get_cli_ret(), common.getMsg(
                self.lang, 'query.result.abnormal')
