# -*- coding: UTF-8 -*-

from frameone.cli import cliUtil
from business.common import common
from frameone.util import contextUtil

from cbb.frame.ruleConfig import common as cbb_common
from cbb.business.checkitems.disk_domain_smo_check import DiskDomainSmoCheck
from cbb.frame.base.exception import UnCheckException


def execute(context):
    """硬盘域空间图对象检查
    :param context:
    :return:
    """
    all_ret = []
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)

    try:
        cli = contextUtil.getSSH(context)
        p_version = contextUtil.getCurVersion(context)
        p_model = contextUtil.getDevType(context)
        ret = "Product Model:{}\nProduct Version:{}\n".format(
            p_model, p_version
        )
        all_ret.append(ret)
        logger.logInfo(ret)
        flag, p_patch, ret, msg = common.getHotPatchVersion(cli, lang)
        all_ret.append(ret)
        if flag is not True:
            return common.getUpgEvaluationRs(
                cliUtil.RESULT_NOCHECK, "\n".join(all_ret), msg
            )

        dd_smo_check = DiskDomainSmoCheck(
            cli, lang, logger, p_version, p_patch, p_model
        )
        risk_flag = dd_smo_check.execute_check()
        all_ret.extend(dd_smo_check.all_cli_ret)
        all_cli_ret = "\n".join(all_ret)
        if risk_flag:
            return common.getUpgEvaluationRs(risk_flag, all_cli_ret, "")

        target_patch = dd_smo_check.patch_version_dict.get(p_version)
        err_msg = "disk.domain.smo.check.not.pass"
        return common.getUpgEvaluationRs(
            risk_flag,
            all_cli_ret,
            cbb_common.getMsg(lang, err_msg, target_patch),
        )

    except UnCheckException as e:
        return common.getUpgEvaluationRs(
            cliUtil.RESULT_NOCHECK, "\n".join(all_ret), e.errMsg
        )

    except Exception:
        err_key = "query.result.abnormal"
        return common.getUpgEvaluationRs(
            cliUtil.RESULT_NOCHECK,
            "\n".join(all_ret),
            cbb_common.getMsg(lang, err_key),
        )
