# -*- coding: UTF-8 -*-
from business.common import common

from frameone.util import contextUtil
from frameone.cli import cliUtil

from cbb.business.checkitems.cli_domain_config_check import (
    CliDomainConfigCheck,
)
from cbb.frame.util import contextUtil4Evalu
from cbb.frame.base.exception import UnCheckException
from cbb.frame.base import baseUtil
import com.huawei.ism.tool.obase.entity.EntityUtils as EntityUtils


def execute(context):
    """
    跨引擎硬盘域空间分配检查
    :param context:
    :return:
    """
    cli = contextUtil.getSSH(context)
    lang = contextUtil.getLang(context)
    logger = common.getLogger(contextUtil.getLogger(context), __file__)
    dest_version = contextUtil4Evalu.getTargetVersion(context)
    dest_patch = context.get("dev").getUpgPatchPkgVer()
    dev_node = EntityUtils.toOldDev(context.get('dev'))
    product_model = str(dev_node.getDeviceType())
    logger.logInfo("product_model:{}.".format(product_model))
    if baseUtil.is_micro_dev(product_model):
        logger.logInfo("micro dev is not support.")
        return common.getUpgEvaluationRs(cliUtil.RESULT_NOSUPPORT, "", "")

    dest_patch = get_dest_patch(dest_patch, dest_version)
    dest_version = (dest_version if "SPH" not in dest_version else str(dest_version).split("SPH")[0])
    cli_domain_config_check_target = CliDomainConfigCheck(cli, lang, logger, dest_version, dest_patch)
    try:
        all_err_meg_list = list()
        logger.logInfo("target version:{}, patch:{}".format(dest_version, dest_patch))

        flag = cli_domain_config_check_target.execute_check()
        cli_ret = "\n".join(cli_domain_config_check_target.all_cli_ret)
        if flag is True:
            return common.getUpgEvaluationRs(flag, cli_ret, "")

        for param in cli_domain_config_check_target.err_msg_notice:
            all_err_meg_list.append(common.getMsg(lang, "cli.domain.config.check.not.pass", tuple(param), ))
        for param in cli_domain_config_check_target.err_msg_notice_no_smart:
            all_err_meg_list.append(common.getMsg(lang, "cli.domain.config.check.not.pass.no.smart", tuple(param), ))
        return common.getUpgEvaluationRs(flag, "\n".join(cli_domain_config_check_target.all_cli_ret),
                                         "".join(all_err_meg_list), )
    except UnCheckException as e:
        return common.getUpgEvaluationRs(
            cliUtil.RESULT_NOCHECK,
            "\n".join(cli_domain_config_check_target.all_cli_ret),
            e.errorMsg,
        )
    except Exception as e:
        logger.logException(e)
        return common.getUpgEvaluationRs(
            cliUtil.RESULT_NOCHECK,
            "\n".join(cli_domain_config_check_target.all_cli_ret),
            common.getMsg(lang, "query.result.abnormal"),
        )


def get_dest_patch(dest_patch, dest_version):
    dest_patch = "SPH{}".format(str(dest_patch).split("SPH")[1]) if dest_patch else ''
    dest_patch = (dest_patch
                  if dest_patch
                  else ("SPH{}".format(str(dest_version).split("SPH")[1]) if "SPH" in dest_version else ""))
    return dest_patch
