# -*- coding: UTF-8 -*-
import traceback

from frameone.util import contextUtil, baseUtil
from frameone.cli import cliUtil
from frameone.base.constants import CheckStatus, CheckResult

def execute(dataDict):
    logger = contextUtil.getLogger(dataDict)
    currentVersion = contextUtil.getCurVersion(dataDict)
    logger.info("currentVersion is %s" % currentVersion)
    if ("V5" in currentVersion and currentVersion < "V500R007C50")\
            or ("V3" in currentVersion and currentVersion < "V300R006C60"):
        logger.info("The device not need check fsmove.")
        return CheckStatus.NO_SUPPORT, "", ""

    checkResult = FsMoveCheck(dataDict).check()
    return checkResult.toScriptResult()

class FsMoveCheck():
    def __init__(self, context):
        self.logger = contextUtil.getLogger(context)
        self.lang = contextUtil.getLang(context)
        self.context = context
        self.originInfos = []
        self.commonMsg = baseUtil.getMsg(self.lang, "query.result.abnormal")

    def check(self):
        try:
            self.cli = contextUtil.getCLI(self.context)
            cmd = "show fs_migration general"
            checkRet = cliUtil.excuteCmdInCliMode(self.cli, cmd, True, self.lang)
            self.originInfos.append(checkRet[1])

            if not cliUtil.hasCliExecPrivilege(checkRet[1]):
                return CheckResult(CheckStatus.PASS, self.originInfos)
            if checkRet[0] != True:
                return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)
            if cliUtil.queryResultWithNoRecord(checkRet[1]):
                return CheckResult(CheckStatus.PASS, self.originInfos)
            errMsg = baseUtil.getMsg(self.lang, "FsmoveCheck.notpass")
            return CheckResult(CheckStatus.NOTPASS, self.originInfos, errMsg)
        except:
            self.logger.error("run excption [%s]" % traceback.format_exc())
            return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)