# -*- coding: UTF-8 -*-
import traceback

from frameone.util import contextUtil, baseUtil
from business.common.config import FTP_SERVICE
from frameone.cli import cliUtil
from frameone.base.constants import CheckStatus, CheckResult

def execute(dataDict):
    logger = contextUtil.getLogger(dataDict)
    # 检查是否在检查版本范围内V300R003C10及之前的版本升级到V300R003C20及之后版本
    currentVersion = contextUtil.getCurVersion(dataDict)
    upgradeVersion = contextUtil.getTargetVersion(dataDict)
    logger.info("upgradeVersion is  %s, currentVersion is %s" % (upgradeVersion, currentVersion))
    if currentVersion < FTP_SERVICE["minCurrentVersion"] or currentVersion >= FTP_SERVICE["maxCurrentVersion"] or upgradeVersion < FTP_SERVICE["minTargetVersion"]:
        logger.info("The device not need check Service ftp.")
        return CheckStatus.NO_SUPPORT, "", ""

    checkResult = FtpCheck(dataDict).check()
    return checkResult.toScriptResult()


class FtpCheck():
    def __init__(self, context):
        self.logger = contextUtil.getLogger(context)
        self.lang = contextUtil.getLang(context)
        self.context = context
        self.originInfos = []
        self.commonMsg = baseUtil.getMsg(self.lang, "query.result.abnormal")

    def check(self):
        try:
            self.cli = contextUtil.getCLI(self.context)
            cmd = "show service ftp"
            checkRet = cliUtil.excuteCmdInCliMode(self.cli, cmd, True, self.lang)
            self.originInfos.append(checkRet[1])

            if not cliUtil.hasCliExecPrivilege(checkRet[1]):
                return CheckResult(CheckStatus.PASS, self.originInfos)
            if checkRet[0] != True:
                return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)
            cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])

            if len(cliRetLinesList) == 0:
                return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)
            runningStatus = cliRetLinesList[0].get("Running Status", "")
            if runningStatus.lower() == "stop":
                return CheckResult(CheckStatus.PASS, self.originInfos)

            acceesSwitch = cliRetLinesList[0].get("Anonymous Access Switch", "")
            if acceesSwitch.lower() == "on":
                errMsg = baseUtil.getMsg(self.lang, "CheckFtpService.notpass")
                return CheckResult(CheckStatus.WARNING, self.originInfos, errMsg)

            return self.checkPermission()
        except:
            self.logger.error("run excption [%s]" % traceback.format_exc())
            return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)

    def checkPermission(self):
        cmd = "show share_permission ftp"
        checkRet = cliUtil.excuteCmdInCliMode(self.cli, cmd, True, self.lang)
        self.originInfos.append(checkRet[1])
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return CheckResult(CheckStatus.PASS, self.originInfos)
        if checkRet[0] != True:
            return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)

        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return CheckResult(CheckStatus.PASS, self.originInfos)

        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            return CheckResult(CheckStatus.NOCHECK, self.originInfos, self.commonMsg)
        errMsg = baseUtil.getMsg(self.lang, "CheckFtpService.notpass")
        return CheckResult(CheckStatus.WARNING, self.originInfos, errMsg)

