# -*- coding: UTF-8 -*-
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus

import time
import os
import traceback
import re
from business.common import util
from frameone.util import baseUtil
from cbb.frame.util.public_ip_address_utils import get_export_event_used_ip
from cbb.frame.util.tar_util import decompress_tar_all_file

cliRest = []
def execute(dataDict):
    dev = dataDict.get("dev")
    logger = dataDict.get("logger")
    ssh  = dataDict.get("ssh")
    lang = dataDict.get("lang")
    #得到当前设备版本
    devVersion = dev.getProductVersion()
    logger.info("[isZoneIndexDuplicate] devVersion:" + devVersion)
    
    #当前版本是否进入受限名单
    if devVersion > "V200R002C00SPC200":
        dataDict['isZoneIndexDuplicateStatus'] = True
        return (0, "","")
    
    dataDict['checkType'] = "PRECHECK"
    errorKey = "isZoneIndexDuplicate.notpass"
    itemState = 4
    cmdRet = util.execCmdRetry(ssh, "show upgrade package")
    cliRest.append(cmdRet)
    cmdRetLines = cmdRet.splitlines()
    #未通过 则检查是否安装补丁
    for Num in range(len(cmdRetLines)):
        if re.search("HotPatch Version", cmdRetLines[Num], re.IGNORECASE):
            thisHotpachVersionStr = cmdRetLines[Num + 4].split()[3].strip()
            logger.info("[isZoneIndexDuplicate] thisHotpachVersionStr:" + thisHotpachVersionStr)
            #如果打过指定补丁，则放过
            if (devVersion == "V200R002C00SPC100") and re.search("SPH199", thisHotpachVersionStr, re.IGNORECASE):
                itemState = 3
                errorKey = "isZoneIndexDuplicate.pass"
                break
            elif (devVersion == "V200R002C00SPC200") and re.search("SPH299", thisHotpachVersionStr, re.IGNORECASE):
                itemState = 3
                errorKey = "isZoneIndexDuplicate.pass"
                break
            elif (devVersion in ["V200R002C00","V200R002C00B020"]) and re.search("SPH099", thisHotpachVersionStr, re.IGNORECASE):
                itemState = 3
                errorKey = "isZoneIndexDuplicate.pass"
                break
            else:#没有打指定的补丁包
                ret = executeCheck(dataDict)
                #不通过
                if not ret[0]:
                    itemState = 4
                    errorKey = ret[1]
                else:#通过
                    itemState = 3
                    errorKey = ret[1]
                    
                break
    #成功标志位  diskDomain检查项根据该标志位决定是否执行
    if itemState == 3:
        dataDict['isZoneIndexDuplicateStatus'] = True
    else:
        dataDict['isZoneIndexDuplicateStatus'] = False
    
    suggession = baseUtil.getMsg(lang, errorKey)
    itemMsg = {
            ##检查项名称，类型String
            ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
            "status":itemState % 3,
            ##修复建议
            "suggession":suggession
        }
        
    return itemMsg["status"], "\n".join(cliRest), itemMsg["suggession"]
    
#*************************************************************************************
#checkEventFile
#描述：根据阵列下载event 文件 分析 Zone是否重复
#传入参数：filePath 本地event文件地址 logger 日志对象
#返回值：（boolean1 , boolean2）  boolean1 =True表示整个解析过程没异常 ；boolean2=True表示zone没有重复。检查通过
#boolean2 = False 表示检测到重复 检查不通过
#*************************************************************************************
def checkEventFile(filePath, logger):
    try:
        eventNum = getEventNum(filePath)
        logger.info('[isZoneIndexDuplicate] Event number is:' + str(eventNum))
        
        if eventNum > 49000:
            logger.error('[isZoneIndexDuplicate] Event number is bigger than 49000, check failed!')
            return (True, False)
        
        fileRet = open(filePath)
        lines = fileRet.read().splitlines()
        arrayUpgradeLine = -1
        
        #保存 0x2000010A0012 数据
        c00NewDiskDomainIdList = ["0"]
        #保存 0x200000D80003、0x200000D80004 数据
        c00NewPoolDiskDomainIdList = []
        c00NewPoolIdList =["0"]
        
        #找到最近跨版本升级时间点
        for arrayUpgradeLineNum in range(len(lines)):
            if re.search("0x200F010D001A" , lines[arrayUpgradeLineNum] ,re.IGNORECASE):
                if re.search("succeeded in starting the upgrade \(upgrade procedure check before upgrade" , lines[arrayUpgradeLineNum] ,re.IGNORECASE):
                    arrayUpgradeLine = arrayUpgradeLineNum
                    logger.info("[isZoneIndexDuplicate] arrayUpgradeLine:" + str(arrayUpgradeLineNum) +"lineStr:" +lines[arrayUpgradeLineNum])
                    break
            
        #没找到升级成功标志 就搜索全文
        if  -1 == arrayUpgradeLine:
            logger.info("[isZoneIndexDuplicate] not search arrayUpgradeLine!")
            arrayUpgradeLine = len(lines)
            
        #保存 0x2000010A0012 事件ID 的disk_domain ID
        for lineNum in range(0,arrayUpgradeLine):
            
            if re.search("0x2000010A0012" , lines[lineNum] ,re.IGNORECASE):
                
                logger.info("[isZoneIndexDuplicate] search A0012 line:" +str(lineNum) +"lineStr:" +lines[lineNum] )
                #得到ID 添加到临时保存对象中
                diskDomainId = lines[lineNum].split(",")[0].split("ID")[-1].strip()
                c00NewDiskDomainIdList.append(diskDomainId)
                
            #保存 0x200000D80003、0x200000D80004 事件ID 的disk_domain ID 和 pool ID
            if re.search("0x200000D80003|0x200000D80004" , lines[lineNum] ,re.IGNORECASE):
                
                logger.info("[isZoneIndexDuplicate] search D80003 or D80004 line:" +str(lineNum) +"lineStr:" +lines[lineNum] )
                #得到pool ID 添加到临时保存对象中
                poolId = lines[lineNum].split(",")[0].split("ID")[-1].strip()
                c00NewPoolIdList.append(poolId)
                #得到 disk domain Id 
                diskDomainId = lines[lineNum].split("disk domain id")[1].split(",")[0].strip()
                c00NewPoolDiskDomainIdList.append(diskDomainId)
        
        #优化 集合  newDiskDomainId 、c00NewPoolDiskDomainIdList 、 c00NewPoolIdList 提升效率
        c00NewDiskDomainIdList = list(set(c00NewDiskDomainIdList))
        c00NewPoolIdList = list(set(c00NewPoolIdList))
        c00NewPoolDiskDomainIdList = list(set(c00NewPoolDiskDomainIdList))
            
        #如果diskDomainList2 不是 c00NewDiskDomainIdList 的子集等则存在风险
        for newDiskDomainId in c00NewPoolDiskDomainIdList:
            if newDiskDomainId not in c00NewDiskDomainIdList:
                logger.info("[isZoneIndexDuplicate] check disk domain error! c00NewDiskDomainIdList = " + str(c00NewDiskDomainIdList) +":c00NewPoolDiskDomainIdList = "+ str(c00NewPoolDiskDomainIdList))
                return (True, False)
            
        #扩Tier操作的 pool ID是否在新建的poolID的列表中
        for lineNum in range(0,arrayUpgradeLine):
            if re.search("0x200000D8000D|0x200000D8000E" , lines[lineNum] ,re.IGNORECASE):
                
                logger.info("[isZoneIndexDuplicate] search D8000D or D8000E line:" +str(lineNum) +"lineStr:" +lines[lineNum] )
                #得到pool ID
                poolId = lines[lineNum].split("(ID")[1].split(",")[0].strip()
                
                #如果扩Tier 的pool不在升级后 pool里面说明检查不通过
                if poolId not in c00NewPoolIdList:
                    logger.info("[isZoneIndexDuplicate] check pool error! c00NewPoolIdList = " + str(c00NewPoolIdList))
                    return (True, False)
                
        return (True, True)
    except:
        logger.error("[isZoneIndexDuplicate] check event error!" +traceback.format_exc())
        return (False, False)
    finally:
        #关闭文件
        try:
            fileRet.close()
        except:
            logger.error("[isZoneIndexDuplicate] check event error!" +traceback.format_exc())
        
        
def getEventNum(file):
    lineNum = 0
    for line in open(file):
        if '   0x' in line:
            lineNum += 1
    return lineNum

    
# **************************************************************************** #
# 函数名称: decompressPKG
# 功能说明: 解压告警文件
# 输入参数: filePath，depressPath
# **************************************************************************** #
def decompressPKG(filePath, depressPath):
    decompress_tar_all_file(filePath, depressPath)
#*************************************************************************************
#executeCheck
#辅助检查方法，方便设置检查结果
#返回值：boolean ,message : boolean  表示检查结果 True通过 False不通过。message 执行结果对应的修复建议的键
#*************************************************************************************
def executeCheck(dataDict):
    dev = dataDict.get("dev")
    logger = dataDict.get("logger")
    ssh  = dataDict.get("ssh")
    sftp = dataDict.get("sftp")
    exportFilePath = ""
    #执行导出 event 
    cmdStr = "show file export_path file_type=event"
    exportEventRet = util.execCmdRetry(ssh, cmdStr)
    cliRest.append(exportEventRet)
    if -1 != exportEventRet.find("^"):
        strCmd_old = "export event event_type=event ip={} " \
                     "user=admin password=****** path=/collect_alm.tgz " \
                     "clean_device_file=no".format(get_export_event_used_ip())
        exportEventRet = util.execCmdRetry(ssh, strCmd_old)
        exportFilePath = "/OSM/export_import/event_export.tar"
        if not isValidCLIinfo(exportEventRet):
            #删除阵列文件
            util.execCmdRetry(ssh, "delete file filetype=event")
            return (False, "isZoneIndexDuplicate.exportFileError")
    else:
        #如果导出成功便会出现该回显
        if -1 == exportEventRet.find("File Path :"):
            logger.error("[isZoneIndexDuplicate] export file error!")
            return (False, "isZoneIndexDuplicate.exportFileError")
        #得到阵列存放目录
        for line in exportEventRet.splitlines():
            if -1 != line.find("File Path :"):
                exportFilePath = line.split(":")[-1].strip()
            
    localScriptPath = os.path.realpath(__file__)
    #产生零时存放目录
    # IPV6创建文件夹失败 Begin
    localScriptPath +="/../../" + dev.getIp().replace(":", ".") + "_eventFile/"
    # IPV6创建文件夹失败 End
    #解压后的event文件全路径
    localEventFilePath = localScriptPath + "local_alm_file.txt"
    #防止出错
    try:
        #如果本地临时目录不存在，则创建
        if os.path.exists(localScriptPath) != True:
            os.mkdir(localScriptPath)
        
        logger.info("[isZoneIndexDuplicate] exportFilePath =" + exportFilePath  + " :localScriptPath=" + localScriptPath)
        #从阵列下载到本地
        sftp.getFile(exportFilePath, localScriptPath,None)
        #压缩包全路径
        tarPath = localScriptPath + exportFilePath.split("/")[-1]
        #解压
        decompressPKG(tarPath, localScriptPath)
    except:
        logger.error("[isZoneIndexDuplicate] traceback:" + traceback.format_exc())
        logger.error("[isZoneIndexDuplicate] down load file error!")
        return (False, "isZoneIndexDuplicate.downFileError")
    finally:
        #删除阵列文件
        util.execCmdRetry(ssh, "delete file filetype=event")
    #开始解析
    checkEventFileRet = checkEventFile(localEventFilePath, logger)
    if not checkEventFileRet[0]:#解析异常
        return (False, "isZoneIndexDuplicate.checkFileError")
    
    if not checkEventFileRet[1]:#检查不通过
        return (False, "isZoneIndexDuplicate.notpass")
    #检查通过
    return (True, "isZoneIndexDuplicate.pass")

def isValidCLIinfo(cliRet):       
    index_1 = cliRet.find("Error: Sftp put file failed")
    index_2 = cliRet.find("Error: Collection succeeded but the Sftp put file failed")
    index_3 = cliRet.find("Command executed successfully.")
    index_4 = cliRet.find("Collection succeeded and the command was successfully executed")
    index_5 = cliRet.find("Error: Part of information was successfully collected but the Sftp put file failed")
    index_6 = cliRet.find("Part of infomration was successfully collected and the command was successfully executed")
    index_7 = cliRet.find("Error: Sftp get file failed.")
    index_8 = cliRet.find("File Path : /OSM/export_import/")
    #系统未在正确模式下
    if -1 == cliRet.find(":/>"):
        return False
    
    if(-1 != cliRet.find("The system is busy. Please try again later")):
        return False
        
    if((-1 != cliRet.find("-bash: export")) or (-1 != cliRet.find("minisystem"))):
        return False
    
    if ((index_1 == -1) and (index_2 == -1) and (index_3 == -1) and (index_4 == -1) and (index_5 == -1) and (index_6 == -1) and (index_7 == -1)) and (index_8 == -1):
        return False
    return True